<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class ServiceDefinition extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var array<string, ServiceResource>
     */
    protected $resources;

    /**
     * @var array<string, ServiceExternalResource>
     */
    protected $externalResources;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->initialized['name'] = true;
        $this->name = $name;

        return $this;
    }

    /**
     * @return array<string, ServiceResource>
     */
    public function getResources(): iterable
    {
        return $this->resources;
    }

    /**
     * @param array<string, ServiceResource> $resources
     */
    public function setResources(iterable $resources): self
    {
        $this->initialized['resources'] = true;
        $this->resources = $resources;

        return $this;
    }

    /**
     * @return array<string, ServiceExternalResource>
     */
    public function getExternalResources(): iterable
    {
        return $this->externalResources;
    }

    /**
     * @param array<string, ServiceExternalResource> $externalResources
     */
    public function setExternalResources(iterable $externalResources): self
    {
        $this->initialized['externalResources'] = true;
        $this->externalResources = $externalResources;

        return $this;
    }
}
