<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class SchemasVeterinaryEstablishmentServiceSubscriptionRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var SchemasVeterinaryEstablishmentServiceSubscriptionRequestAttributesItem[]
     */
    protected $attributes;

    /**
     * @var \DateTime
     */
    protected $from;

    /**
     * @var bool
     */
    protected $isRenewal;

    /**
     * @var string
     */
    protected $paymentMethod;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $specificBillingAccount;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $specificVeterinaryGroup;

    /**
     * @var \DateTime
     */
    protected $to;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * @return SchemasVeterinaryEstablishmentServiceSubscriptionRequestAttributesItem[]
     */
    public function getAttributes(): array
    {
        return $this->attributes;
    }

    /**
     * @param SchemasVeterinaryEstablishmentServiceSubscriptionRequestAttributesItem[] $attributes
     */
    public function setAttributes(array $attributes): self
    {
        $this->initialized['attributes'] = true;
        $this->attributes = $attributes;

        return $this;
    }

    public function getFrom(): \DateTime
    {
        return $this->from;
    }

    public function setFrom(\DateTime $from): self
    {
        $this->initialized['from'] = true;
        $this->from = $from;

        return $this;
    }

    public function getIsRenewal(): bool
    {
        return $this->isRenewal;
    }

    public function setIsRenewal(bool $isRenewal): self
    {
        $this->initialized['isRenewal'] = true;
        $this->isRenewal = $isRenewal;

        return $this;
    }

    public function getPaymentMethod(): string
    {
        return $this->paymentMethod;
    }

    public function setPaymentMethod(string $paymentMethod): self
    {
        $this->initialized['paymentMethod'] = true;
        $this->paymentMethod = $paymentMethod;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getSpecificBillingAccount(): ?NullableIdRequest
    {
        return $this->specificBillingAccount;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setSpecificBillingAccount(?NullableIdRequest $specificBillingAccount): self
    {
        $this->initialized['specificBillingAccount'] = true;
        $this->specificBillingAccount = $specificBillingAccount;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getSpecificVeterinaryGroup(): ?NullableIdRequest
    {
        return $this->specificVeterinaryGroup;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setSpecificVeterinaryGroup(?NullableIdRequest $specificVeterinaryGroup): self
    {
        $this->initialized['specificVeterinaryGroup'] = true;
        $this->specificVeterinaryGroup = $specificVeterinaryGroup;

        return $this;
    }

    public function getTo(): \DateTime
    {
        return $this->to;
    }

    public function setTo(\DateTime $to): self
    {
        $this->initialized['to'] = true;
        $this->to = $to;

        return $this;
    }
}
