<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class ManufacturerResponseItem extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var ManufacturerResponseItemBanner|null
     */
    protected $banner;

    /**
     * @var string
     */
    protected $code;

    /**
     * @var ManufacturerResponseItemLegalStructure
     */
    protected $legalStructure;

    /**
     * @var ManufacturerResponseItemLogo|null
     */
    protected $logo;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var ManufacturerResponseItemPicturesItem[]|null
     */
    protected $pictures;

    /**
     * @var string
     */
    protected $type;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    public function getBanner(): ?ManufacturerResponseItemBanner
    {
        return $this->banner;
    }

    public function setBanner(?ManufacturerResponseItemBanner $banner): self
    {
        $this->initialized['banner'] = true;
        $this->banner = $banner;

        return $this;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->initialized['code'] = true;
        $this->code = $code;

        return $this;
    }

    public function getLegalStructure(): ManufacturerResponseItemLegalStructure
    {
        return $this->legalStructure;
    }

    public function setLegalStructure(ManufacturerResponseItemLegalStructure $legalStructure): self
    {
        $this->initialized['legalStructure'] = true;
        $this->legalStructure = $legalStructure;

        return $this;
    }

    public function getLogo(): ?ManufacturerResponseItemLogo
    {
        return $this->logo;
    }

    public function setLogo(?ManufacturerResponseItemLogo $logo): self
    {
        $this->initialized['logo'] = true;
        $this->logo = $logo;

        return $this;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->initialized['name'] = true;
        $this->name = $name;

        return $this;
    }

    /**
     * @return ManufacturerResponseItemPicturesItem[]|null
     */
    public function getPictures(): ?array
    {
        return $this->pictures;
    }

    /**
     * @param ManufacturerResponseItemPicturesItem[]|null $pictures
     */
    public function setPictures(?array $pictures): self
    {
        $this->initialized['pictures'] = true;
        $this->pictures = $pictures;

        return $this;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): self
    {
        $this->initialized['type'] = true;
        $this->type = $type;

        return $this;
    }
}
