<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class InvoiceResponseItem extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var string
     */
    protected $accountingCode;

    /**
     * @var InvoiceResponseItemAccountingMovement
     */
    protected $accountingMovement;

    /**
     * @var int
     */
    protected $amountWithoutVat;

    /**
     * @var int
     */
    protected $amountWithVat;

    /**
     * @var InvoiceResponseItemBankAccount
     */
    protected $bankAccount;

    /**
     * @var string
     */
    protected $category;

    /**
     * @var InvoiceAddressResponse
     */
    protected $deliveryAddress;

    /**
     * @var InvoiceResponseItemDeliveryInformation
     */
    protected $deliveryInformation;

    /**
     * @var string
     */
    protected $entitled;

    /**
     * @var InvoiceResponseItemInvoiceLinesItem[]
     */
    protected $invoiceLines;

    /**
     * @var string
     */
    protected $paymentMethod;

    /**
     * @var string
     */
    protected $paymentStatus;

    /**
     * @var string|null
     */
    protected $personalisedMention;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $pdfDocument;

    /**
     * @var InvoiceAddressResponse
     */
    protected $receiverAddress;

    /**
     * @var InvoiceResponseItemReceiverInformation
     */
    protected $receiverInformation;

    /**
     * @var InvoiceAddressResponse
     */
    protected $senderAddress;

    /**
     * @var InvoiceResponseItemSenderInformation
     */
    protected $senderInformation;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    public function getAccountingCode(): string
    {
        return $this->accountingCode;
    }

    public function setAccountingCode(string $accountingCode): self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;

        return $this;
    }

    public function getAccountingMovement(): InvoiceResponseItemAccountingMovement
    {
        return $this->accountingMovement;
    }

    public function setAccountingMovement(InvoiceResponseItemAccountingMovement $accountingMovement): self
    {
        $this->initialized['accountingMovement'] = true;
        $this->accountingMovement = $accountingMovement;

        return $this;
    }

    public function getAmountWithoutVat(): int
    {
        return $this->amountWithoutVat;
    }

    public function setAmountWithoutVat(int $amountWithoutVat): self
    {
        $this->initialized['amountWithoutVat'] = true;
        $this->amountWithoutVat = $amountWithoutVat;

        return $this;
    }

    public function getAmountWithVat(): int
    {
        return $this->amountWithVat;
    }

    public function setAmountWithVat(int $amountWithVat): self
    {
        $this->initialized['amountWithVat'] = true;
        $this->amountWithVat = $amountWithVat;

        return $this;
    }

    public function getBankAccount(): InvoiceResponseItemBankAccount
    {
        return $this->bankAccount;
    }

    public function setBankAccount(InvoiceResponseItemBankAccount $bankAccount): self
    {
        $this->initialized['bankAccount'] = true;
        $this->bankAccount = $bankAccount;

        return $this;
    }

    public function getCategory(): string
    {
        return $this->category;
    }

    public function setCategory(string $category): self
    {
        $this->initialized['category'] = true;
        $this->category = $category;

        return $this;
    }

    public function getDeliveryAddress(): InvoiceAddressResponse
    {
        return $this->deliveryAddress;
    }

    public function setDeliveryAddress(InvoiceAddressResponse $deliveryAddress): self
    {
        $this->initialized['deliveryAddress'] = true;
        $this->deliveryAddress = $deliveryAddress;

        return $this;
    }

    public function getDeliveryInformation(): InvoiceResponseItemDeliveryInformation
    {
        return $this->deliveryInformation;
    }

    public function setDeliveryInformation(InvoiceResponseItemDeliveryInformation $deliveryInformation): self
    {
        $this->initialized['deliveryInformation'] = true;
        $this->deliveryInformation = $deliveryInformation;

        return $this;
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function setEntitled(string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    /**
     * @return InvoiceResponseItemInvoiceLinesItem[]
     */
    public function getInvoiceLines(): array
    {
        return $this->invoiceLines;
    }

    /**
     * @param InvoiceResponseItemInvoiceLinesItem[] $invoiceLines
     */
    public function setInvoiceLines(array $invoiceLines): self
    {
        $this->initialized['invoiceLines'] = true;
        $this->invoiceLines = $invoiceLines;

        return $this;
    }

    public function getPaymentMethod(): string
    {
        return $this->paymentMethod;
    }

    public function setPaymentMethod(string $paymentMethod): self
    {
        $this->initialized['paymentMethod'] = true;
        $this->paymentMethod = $paymentMethod;

        return $this;
    }

    public function getPaymentStatus(): string
    {
        return $this->paymentStatus;
    }

    public function setPaymentStatus(string $paymentStatus): self
    {
        $this->initialized['paymentStatus'] = true;
        $this->paymentStatus = $paymentStatus;

        return $this;
    }

    public function getPersonalisedMention(): ?string
    {
        return $this->personalisedMention;
    }

    public function setPersonalisedMention(?string $personalisedMention): self
    {
        $this->initialized['personalisedMention'] = true;
        $this->personalisedMention = $personalisedMention;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getPdfDocument(): IdResponse
    {
        return $this->pdfDocument;
    }

    /**
     * Id - Response Model.
     */
    public function setPdfDocument(IdResponse $pdfDocument): self
    {
        $this->initialized['pdfDocument'] = true;
        $this->pdfDocument = $pdfDocument;

        return $this;
    }

    public function getReceiverAddress(): InvoiceAddressResponse
    {
        return $this->receiverAddress;
    }

    public function setReceiverAddress(InvoiceAddressResponse $receiverAddress): self
    {
        $this->initialized['receiverAddress'] = true;
        $this->receiverAddress = $receiverAddress;

        return $this;
    }

    public function getReceiverInformation(): InvoiceResponseItemReceiverInformation
    {
        return $this->receiverInformation;
    }

    public function setReceiverInformation(InvoiceResponseItemReceiverInformation $receiverInformation): self
    {
        $this->initialized['receiverInformation'] = true;
        $this->receiverInformation = $receiverInformation;

        return $this;
    }

    public function getSenderAddress(): InvoiceAddressResponse
    {
        return $this->senderAddress;
    }

    public function setSenderAddress(InvoiceAddressResponse $senderAddress): self
    {
        $this->initialized['senderAddress'] = true;
        $this->senderAddress = $senderAddress;

        return $this;
    }

    public function getSenderInformation(): InvoiceResponseItemSenderInformation
    {
        return $this->senderInformation;
    }

    public function setSenderInformation(InvoiceResponseItemSenderInformation $senderInformation): self
    {
        $this->initialized['senderInformation'] = true;
        $this->senderInformation = $senderInformation;

        return $this;
    }
}
