<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class CreditNoteResponseCreditNoteLinesItem extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var int
     */
    protected $amountWithoutVat;

    /**
     * @var int
     */
    protected $amountWithVat;

    /**
     * @var string
     */
    protected $entitled;

    /**
     * @var string
     */
    protected $vatCategory;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getAmountWithoutVat(): int
    {
        return $this->amountWithoutVat;
    }

    public function setAmountWithoutVat(int $amountWithoutVat): self
    {
        $this->initialized['amountWithoutVat'] = true;
        $this->amountWithoutVat = $amountWithoutVat;

        return $this;
    }

    public function getAmountWithVat(): int
    {
        return $this->amountWithVat;
    }

    public function setAmountWithVat(int $amountWithVat): self
    {
        $this->initialized['amountWithVat'] = true;
        $this->amountWithVat = $amountWithVat;

        return $this;
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function setEntitled(string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    public function getVatCategory(): string
    {
        return $this->vatCategory;
    }

    public function setVatCategory(string $vatCategory): self
    {
        $this->initialized['vatCategory'] = true;
        $this->vatCategory = $vatCategory;

        return $this;
    }
}
