<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Endpoint;

class PostVeterinaryEstablishmentUserInvitation extends \NoahVet\Reef\Jane\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Jane\Runtime\Client\Endpoint
{
    use \NoahVet\Reef\Jane\Runtime\Client\EndpointTrait;

    /**
     * Create a Veterinary Establishment User Invitation.
     * A Veterinary Establishment User Invitations is an invitation to join a veterinary establishment.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     */
    public function __construct(\NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserInvitationRequest $requestBody, array $headerParameters = [])
    {
        $this->body = $requestBody;
        $this->headerParameters = $headerParameters;
    }

    public function getMethod(): string
    {
        return 'POST';
    }

    public function getUri(): string
    {
        return '/v1/veterinary_establishment_user_invitations';
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        if ($this->body instanceof \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserInvitationRequest) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }

        return [[], null];
    }

    public function getExtraHeaders(): array
    {
        return ['Accept' => ['application/json']];
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }

    protected function getHeadersOptionsResolver(): \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);

        return $optionsResolver;
    }

    /**
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserInvitationResponse
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentUserInvitationBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentUserInvitationConflictException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if ((null === $contentType) === false && (201 === $status && false !== \mb_strpos($contentType, 'application/json'))) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentUserInvitationResponse', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentUserInvitationBadRequestException($response);
        }
        if (409 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentUserInvitationConflictException($response);
        }
        throw new \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException($status, $body);
    }
}
