<?php

declare(strict_types=1);

namespace NoahVet\Reef\Factory\RequestContext;

use Symfony\Component\HttpFoundation\Request;

class RequestContextFactory implements RequestContextFactoryInterface
{
    public function __construct(
        private readonly PermissionApplierInterface $permissionApplier,
        private readonly FilterApplierInterface $filterApplier,
        private readonly SortingApplierInterface $sortingApplier,
        private readonly KeywordApplierInterface $keywordApplier,
    ) {
    }

    public function createContextFromRequest(Request $request, array $whitelist): array
    {
        return [
            'permissions' => $this->permissionApplier->apply($request, $whitelist),
            'filters' => $this->filterApplier->apply($request, $whitelist),
            'sorting' => $this->sortingApplier->apply($request, $whitelist),
            'keywords' => $this->keywordApplier->apply($request, $whitelist),
        ];
    }
}
