<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Tool;

interface ArrayToolInterface extends ToolInterface
{
    /**
     * @param array<string, mixed> $array
     * @param array<string>        $whitelist
     *
     * @return array<string, mixed>
     */
    public static function applyWhitelistedKeys(array $array, array $whitelist): array;

    /**
     * Before.
     *
     * [
     *   0 => [
     *     "id" => "   test    "
     *   ]
     *   1 => [
     *     "id" => "   te  st2   "
     *   ]
     * ]
     *
     * After
     *
     * [
     *   0 => [
     *     "id" => "test"
     *   ]
     *   1 => [
     *     "id" => "te  st2"
     *   ]
     * ]
     */
    public static function applyTrimRecursive(mixed &$data): void;

    /**
     * @param array<string, mixed> $array
     */
    public static function isArrayExist(array $array, string $key): bool;

    /**
     * @param array<int<0, max>, mixed> $array
     *
     * @return array<int<0, max>, mixed>
     */
    public static function removeDeepDuplicateValues(array $array, string $key): array;

    /**
     * @param array<string, mixed> $array
     */
    public static function removeKeyRecursive(array &$array, string ...$keys): void;

    /**
     * @param array<string|int, mixed> $array
     *
     * @return array<string|int, mixed>
     */
    public static function removeDuplicateValues(array $array): array;

    /**
     * Before.
     *
     * [
     *   0 => [
     *     "id" => "eb0220aa-8731-4afe-9a62-e6c3fa13b7f2"
     *   ]
     *   1 => [
     *     "id" => "eb0220aa-8731-4afe-9a62-e6c3fa13b7f2"
     *   ]
     *   2 => [
     *     "id" => "eb0220aa-8731-4afe-9a62-e6c3fa13b7f2"
     *   ]
     * ]
     *
     * After
     *
     * [
     *   0 => [
     *     "id" => "eb0220aa-8731-4afe-9a62-e6c3fa13b7f2"
     *   ]
     * ]
     *
     * @param array<string|int, mixed> $array
     *
     * @return \Generator<int, non-empty-array<string, mixed>, mixed, void>
     */
    public static function removeDuplicates(array $array, string $key): iterable;

    /**
     * @param array<string|int, mixed> $array
     *
     * @return array<string|int, mixed>
     */
    public static function sortMultiDimensionalByKey(array $array): array;
}
