<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\BusinessRule;

use NoahVet\Reef\Domain\Tool\DateTool;

class DateComparisonBusinessRule implements DateComparisonBusinessRuleInterface
{
    public function endDateShouldBeTheLastDayOfTheYear(
        \DateTimeInterface $startDate,
        \DateTimeInterface $endDate,
    ): bool {
        return DateTool::toLastSecondOfTheYear($startDate) == $endDate;
    }

    public function endDateShouldBeGreaterThanOrEqualsToTheLastDayOfTheYear(
        \DateTimeInterface $startDate,
        \DateTimeInterface $endDate,
    ): bool {
        return DateTool::toLastSecondOfTheYear($startDate) >= $endDate;
    }

    public function periodShouldNotExceedOneYear(
        \DateTimeInterface $startDate,
        \DateTimeInterface $endDate,
    ): bool {
        return 0 === $startDate->diff($endDate)->y;
    }

    public function shouldBeGreaterThan(
        \DateTimeInterface $startDate,
        \DateTimeInterface $endDate,
    ): bool {
        return $startDate < $endDate;
    }

    public function shouldBeGreaterThanNow(
        \DateTimeInterface $date,
    ): bool {
        return $this->shouldBeGreaterThan(new \DateTime(), $date);
    }
}
