<?php

declare(strict_types=1);

namespace NoahVet\Reef\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController as BaseController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

abstract class AbstractController extends BaseController implements ControllerInterface
{
    /**
     * @psalm-suppress UninitializedProperty - Covered by "calls:" in Resources/config/service/controller.yaml
     * @psalm-suppress PropertyNotSetInConstructor - Covered by "calls:" in Resources/config/service/controller.yaml
     */
    protected Request $request;

    /**
     * @var array<string, mixed>
     */
    protected array $whitelist = [
        'filters' => [],
        'sorting' => [],
    ];

    public function setRequest(Request $request): void
    {
        $this->request = $request;
    }

    protected function getNoContentResponse(): Response
    {
        return new JsonResponse(
            null,
            Response::HTTP_NO_CONTENT,
        );
    }
}
