<?php

declare(strict_types=1);

namespace NoahVet\Reef\BusinessRule\Doctrine;

use NoahVet\Reef\Entity\DisableInterface;
use NoahVet\Reef\Entity\EntityInterface;
use NoahVet\Reef\Repository\BaseRepositoryInterface;

interface EntityBusinessRuleInterface
{
    /**
     * @template T of \Exception
     *
     * @param array<string, mixed> $params
     * @param class-string<T>      $exceptionFQCN
     *
     * @psalm-suppress UnsafeInstantiation
     */
    public function entityShouldBeExist(
        array $params,
        BaseRepositoryInterface $repository,
        string $exceptionFQCN = \LogicException::class,
        ?string $exceptionMessage = null,
    ): EntityInterface;

    /**
     * @template T of \Exception
     *
     * @param class-string<T> $exceptionFQCN
     *
     * @psalm-suppress UnsafeInstantiation
     */
    public function entityShouldBeExistById(
        string $id,
        BaseRepositoryInterface $repository,
        string $exceptionFQCN = \LogicException::class,
        ?string $exceptionMessage = null,
    ): EntityInterface;

    /**
     * @template T of \Exception
     *
     * @param class-string<T>      $exceptionFQCN
     * @param array<string, mixed> $params
     *
     * @psalm-suppress UnsafeInstantiation
     */
    public function entityShouldNotBeExist(
        array $params,
        BaseRepositoryInterface $repository,
        string $exceptionFQCN = \LogicException::class,
        ?string $exceptionMessage = null,
    ): self;

    /**
     * @template T of \Exception
     *
     * @param class-string<T> $exceptionFQCN
     *
     * @psalm-suppress UnsafeInstantiation
     *
     * @return $this
     */
    public function entityShouldNotBeDisabled(
        EntityInterface&DisableInterface $entity,
        string $exceptionFQCN = \LogicException::class,
        ?string $exceptionMessage = 'This entity is disabled.',
    ): self;
}
