<?php

declare(strict_types=1);

namespace NoahVet\Reef\Business\Enumerator\Factory;

use NoahVet\Reef\Business\Enumerator\ManufacturerWithTeamEnumerator;
use NoahVet\Reef\Business\Model\Factory\ManufacturerWithTeamFactory;
use NoahVet\Reef\Business\Model\Factory\TeamMemberFactory;
use NoahVet\Reef\Jane\Client;

class ManufacturerWithTeamEnumeratorFactory
{
    public function __construct(
        protected ManufacturerEnumeratorFactory $manufacturerEnumeratorFactory,
        protected ManufacturerTeamMembersEnumeratorFactory $manufacturerTeamMembersEnumeratorFactory,
        protected TeamMemberFactory $teamMemberFactory,
    ) {
    }

    public function create(Client $client): ManufacturerWithTeamEnumerator
    {
        return new ManufacturerWithTeamEnumerator(
            $this->manufacturerEnumeratorFactory->create($client),
            new ManufacturerWithTeamFactory(
                $this->manufacturerTeamMembersEnumeratorFactory->create($client),
                $this->teamMemberFactory,
            ),
        );
    }
}
