<?php

declare(strict_types=1);

namespace NoahVet\Reef\Business\Enumerator;

use NoahVet\Reef\Business\Model\EstablishmentWithTeam;
use NoahVet\Reef\Business\Model\Factory\EstablishmentWithTeamFactory;

class EstablishmentWithTeamEnumerator
{
    public function __construct(
        protected VeterinaryEstablishmentEnumerator $establishmentEnumerator,
        protected EstablishmentWithTeamFactory $establishmentWithTeamFactory,
    ) {
    }

    /**
     * @return \Generator<EstablishmentWithTeam>
     */
    public function enumerateAll(int $establishmentBatchSize = 50): \Generator
    {
        $establishments = [];

        foreach ($this->establishmentEnumerator->enumerateAll([], $establishmentBatchSize) as $establishment) {
            $establishments[] = $establishment;

            if (\count($establishments) === $establishmentBatchSize) {
                foreach ($this->establishmentWithTeamFactory->createBatch($establishments) as $item) {
                    yield $item;
                }
                $establishments = [];
            }
        }

        if (!empty($establishments)) {
            foreach ($this->establishmentWithTeamFactory->createBatch($establishments) as $item) {
                yield $item;
            }
        }
    }
}
