<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Security;

use NoahVet\Reef\Security\ReefOAuthAuthenticator;
use NoahVet\Reef\Security\User\Provider\ReefOAuthUserProviderInterface;
use NoahVet\Reef\Security\User\ReefOAuthUser;
use PHPUnit\Framework\TestCase;

class ReefOAuthAuthenticatorTest extends TestCase
{
    public function testLoadUserNoCache(): void
    {
        $userMock = $this->createMock(ReefOAuthUser::class);

        $userProvider = $this->createMock(ReefOAuthUserProviderInterface::class);
        $userProvider
            ->method('loadUser')
            ->with('bearer')
            ->willReturn($userMock)
        ;

        $authenticator = new ReefOAuthAuthenticator([$userProvider]);

        $user = $authenticator->loadUser('bearer');
        self::assertSame($userMock, $user);
    }
}
