<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Phpunit\Fixture;

use NoahVet\Reef\Phpunit\Fixture\PermissionFixture;
use NoahVet\Reef\Phpunit\Fixture\ReefTokenFixture;
use NoahVet\Reef\Security\IAM\Model\ResourceGroupWithMembers;
use NoahVet\Reef\Security\User\ReefOAuthUser;
use PHPUnit\Framework\TestCase;

class ReefTokenFixtureTest extends TestCase
{
    public function testGetToken(): void
    {
        $tokenFixture = new ReefTokenFixture(
            'unit_token',
            null,
        );

        self::assertEquals('unit_token', $tokenFixture->getToken());
    }

    public function testGetUser(): void
    {
        $tokenFixture = new ReefTokenFixture(
            'unit_token',
            null,
        );

        self::assertNull($tokenFixture->getUser());

        $user = new ReefOAuthUser('toto', null);

        $tokenFixture = new ReefTokenFixture(
            'unit_token',
            $user,
        );

        self::assertSame($user, $tokenFixture->getUser());
    }

    public function testGetAllPermissions(): void
    {
        $user = new ReefOAuthUser('toto', null);
        $tokenFixture = new ReefTokenFixture(
            'unit_token',
            $user,
        );

        self::assertEquals([], $tokenFixture->getAllPermissions());

        $permissions = [
            new PermissionFixture(
                ResourceGroupWithMembers::fromStringWithMembers(
                    'reef:phpunit:ResourceType',
                    '*',
                    [],
                ),
                ['permission_read'],
            ),
        ];

        $tokenFixture = new ReefTokenFixture(
            'unit_token',
            $user,
            $permissions,
            false,
        );

        $allPermissions = $tokenFixture->getAllPermissions();
        self::assertCount(1, $allPermissions);
        self::assertSame($permissions[0], $allPermissions[0]);
    }

    public function testIsSuperAdmin(): void
    {
        $user = new ReefOAuthUser('toto', null);
        $tokenFixture = new ReefTokenFixture(
            'unit_token',
            $user,
            [],
            false,
        );

        self::assertFalse($tokenFixture->isSuperAdmin());

        $user = new ReefOAuthUser('toto', null);
        $tokenFixture = new ReefTokenFixture(
            'unit_token',
            $user,
            [],
            true,
        );

        self::assertTrue($tokenFixture->isSuperAdmin());
    }

    public function testGetPermissions(): void
    {
        $user = new ReefOAuthUser('toto', null);
        $permissions = [
            new PermissionFixture(
                ResourceGroupWithMembers::fromStringWithMembers(
                    'reef:phpunit:ResourceType',
                    '*',
                    [],
                ),
                ['permission_read'],
            ),
        ];

        $tokenFixture = new ReefTokenFixture(
            'unit_token',
            $user,
            $permissions,
            false,
        );

        $permission = $tokenFixture->getPermissions(
            'reef:phpunit:ResourceTypes:*',
        );

        self::assertSame($permissions[0], $permission);
        self::assertNull(
            $tokenFixture->getPermissions(
                'reef:phpunit:ResourceType:unkown_id',
            ),
        );
    }
}
