<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Domain\Log;

use NoahVet\Reef\Domain\Log\SimplePrincipal;
use PHPUnit\Framework\TestCase;

final class SimplePrincipalTest extends TestCase
{
    public function testGetIdWhenIdIsCorrect(): void
    {
        $subject = new SimplePrincipal('1edc9897-6a88-691a-9ecb-cbb5def453ba');
        $this->assertSame(
            '1edc9897-6a88-691a-9ecb-cbb5def453ba',
            $subject->getId(),
        );
    }

    public function testThrowLogicExceptionWhenIdIsInvalid(): void
    {
        $this->expectException(\LogicException::class);
        $this->expectExceptionMessage('The principal id `badId` should be a valid uuid.');
        new SimplePrincipal('badId');
    }
}
