<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Domain\BusinessRule;

use NoahVet\Reef\Domain\BusinessRule\PrivilegedCodeBusinessRule;
use NoahVet\Reef\Domain\BusinessRule\PrivilegedCodeBusinessRuleInterface;
use PHPUnit\Framework\TestCase;

class PrivilegedCodeBusinessRuleTest extends TestCase
{
    private PrivilegedCodeBusinessRuleInterface $subject;

    protected function setUp(): void
    {
        $this->subject = new PrivilegedCodeBusinessRule();
    }

    public function testShouldNotContainABlacklistedWordWithGoodPrivilegedCode(): void
    {
        $privilegedCode = 'GRP001';

        self::assertTrue(
            $this->subject->shouldNotContainABlacklistedWord($privilegedCode),
        );
    }

    public function testShouldNotContainABlacklistedWordWithBlacklistedWord(): void
    {
        $privilegedCode = 'CUL001';

        self::assertFalse(
            $this->subject->shouldNotContainABlacklistedWord($privilegedCode),
        );
    }

    public function testShouldNotContainTheSameLetterTwiceConsecutivelyWithGoodPrivilegedCode(): void
    {
        $privilegedCode = 'GRP001';

        self::assertTrue(
            $this->subject->shouldNotContainTheSameLetterTwiceConsecutively($privilegedCode),
        );
    }

    public function testShouldNotContainTheSameLetterTwiceConsecutivelyWithBadPrivilegedCode(): void
    {
        $privilegedCode = 'GGP001';

        self::assertFalse(
            $this->subject->shouldNotContainTheSameLetterTwiceConsecutively($privilegedCode),
        );

        $privilegedCode = 'GGG001';

        self::assertFalse(
            $this->subject->shouldNotContainTheSameLetterTwiceConsecutively($privilegedCode),
        );

        $privilegedCode = 'PGG001';

        self::assertFalse(
            $this->subject->shouldNotContainTheSameLetterTwiceConsecutively($privilegedCode),
        );
    }
}
