<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Business\Model\Factory;

use NoahVet\Reef\Business\Model\Factory\TeamMemberFactory;
use NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponseItem;
use NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponseItemUser;
use NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponseItemVeterinaryEstablishment;
use PHPUnit\Framework\TestCase;

class TeamMemberFactoryTest extends TestCase
{
    public function testCreate(): void
    {
        $teamMember = new VeterinaryEstablishmentUserResponseItem();
        $teamMemberEst = new VeterinaryEstablishmentUserResponseItemVeterinaryEstablishment();
        $teamMemberEst->setId('phpunit-establishment-id');
        $teamMember->setVeterinaryEstablishment($teamMemberEst);
        $teamMemberUser = new VeterinaryEstablishmentUserResponseItemUser();
        $teamMemberUser->setId('user-id');
        $teamMember->setUser($teamMemberUser);
        $teamMember->setJobTitle('jobtitle');
        $teamMember->setEntryDate(new \DateTime('-5 days'));
        $teamMember->setExitDate(new \DateTime('+5 days'));

        $factory = new TeamMemberFactory();

        $tm = $factory->create($teamMember);
        self::assertEquals('user-id', $tm->getUuid());
        self::assertEquals('jobtitle', $tm->getJobTitle());
        self::assertEquals($teamMember->getEntryDate(), $tm->getEntryDate());
        self::assertEquals($teamMember->getExitDate(), $tm->getExitDate());
    }
}
