<?php

declare(strict_types=1);

namespace NoahVet\Reef\Security\Policy;

interface PolicyInterface
{
    public function getName(): string;

    public function subjectToString(PolicySubjectInterface $subject): string;

    public function computeEtag(PolicySubjectInterface $subject): string;

    public function apply(PolicySubjectInterface $subject): PolicyResult;

    public function canHandle(PolicySubjectInterface $subject): bool;
}
