<?php

declare(strict_types=1);

namespace NoahVet\Reef\Security\Authentication\Token;

use NoahVet\Reef\Security\User\ReefOAuthUser;
use Symfony\Component\Security\Core\Authentication\Token\AbstractToken;

class ReefOAuthToken extends AbstractToken
{
    protected string $bearerToken;

    protected string $firewallName;

    protected \DateTimeImmutable $expiresAt;

    public function __construct(
        string $firewallName,
        string $bearerToken,
        ?ReefOAuthUser $user,
        \DateTimeImmutable $expiresAt,
    ) {
        parent::__construct([]);

        $this->firewallName = $firewallName;
        $this->bearerToken = $bearerToken;
        $this->expiresAt = $expiresAt;

        if ($user) {
            $this->setUser($user);

            // Symfony 5.4
            if (\method_exists($this, 'setAuthenticated')) {
                $this->setAuthenticated(true, false);
            }
        }
    }

    public function getBearerToken(): string
    {
        return $this->bearerToken;
    }

    /**
     * @deprecated since Symfony 5.4
     */
    public function getCredentials(): mixed
    {
        return null;
    }

    public function getExpiresAt(): \DateTimeImmutable
    {
        return $this->expiresAt;
    }

    public function getFirewallName(): string
    {
        return $this->firewallName;
    }
}
