<?php

declare(strict_types=1);

namespace NoahVet\Reef\Repository;

use Doctrine\ORM\QueryBuilder;
use Doctrine\Persistence\ObjectRepository;
use NoahVet\Reef\Entity\EntityInterface;

/**
 * @extends ObjectRepository<EntityInterface>
 */
interface BaseRepositoryInterface extends ObjectRepository
{
    public function countOnId(?QueryBuilder $qb = null): int;

    /**
     * @return array<int, EntityInterface>
     */
    public function findPaginated(int $page, int $limit, ?QueryBuilder $qb = null): array;

    /**
     * @return array<int, EntityInterface>
     */
    public function findAllResult(?QueryBuilder $qb = null): array;

    /**
     * @param array<string, array<int, mixed>> $permissions
     * @param array<string, array<int, mixed>> $filters
     * @param array<string, string>            $sorting
     */
    public function prepareQuery(
        array $permissions = [],
        array $filters = [],
        array $sorting = [],
        string $keywords = '',
        ?QueryBuilder $qb = null,
    ): QueryBuilder;

    public function setLocale(string $locale): self;
}
