<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Producer\Factory;

use NoahVet\Reef\RabbitMQ\Producer\ReefMQProducer;
use NoahVet\Reef\RabbitMQ\Producer\ReefMQProducerInterface;
use NoahVet\Reef\RabbitMQ\RabbitMQConnectionFactoryInterface;
use Symfony\Component\Serializer\SerializerInterface;

class ReefMQProducerFactory implements ReefMQProducerFactoryInterface
{
    protected ?ReefMQProducerInterface $producer = null;

    public function __construct(
        private readonly RabbitMQConnectionFactoryInterface $rabbitMQConnectionFactory,
        private readonly string $reefAppName,
        private readonly SerializerInterface $serializer,
    ) {
    }

    public function getProducer(): ReefMQProducerInterface
    {
        if (!$this->producer) {
            $this->producer = new ReefMQProducer(
                $this->rabbitMQConnectionFactory->get(),
                $this->reefAppName,
                $this->serializer,
            );
        }

        return $this->producer;
    }
}
