<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Notification;

use NoahVet\Reef\Security\IAM\Model\Resource;

interface ReefNotificationInterface
{
    public function getClientId(): string;

    public function getResource(): Resource;

    public function getAction(): string;

    /**
     * @return array<string, string|int|float|bool|array<string, string|int|float|bool>>
     */
    public function getRawData(): array;
}
