<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Message\Handler\Factory;

use NoahVet\Reef\RabbitMQ\Message\Handler\ExecReefAMQPMessageHandler;
use NoahVet\Reef\RabbitMQ\Message\Handler\ProcessReefAMQPMessageHandler;
use NoahVet\Reef\RabbitMQ\Message\Handler\ReefAMQPMessageHandlerInterface;
use Psr\Log\LoggerInterface;

class ReefAMQPMessageHandlerFactory implements ReefAMQPMessageHandlerFactoryInterface
{
    public function __construct(
        private readonly LoggerInterface $logger,
    ) {
    }

    public function create(): ReefAMQPMessageHandlerInterface
    {
        if (\class_exists('Symfony\Component\Process\Process')) {
            return new ProcessReefAMQPMessageHandler($this->logger);
        }

        return new ExecReefAMQPMessageHandler();
    }
}
