<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Consumer\Factory;

use NoahVet\Reef\RabbitMQ\Consumer\ReefMQConsumer;
use NoahVet\Reef\RabbitMQ\Consumer\ReefMQConsumerInterface;
use NoahVet\Reef\RabbitMQ\Message\Handler\ReefAMQPMessageHandlerInterface;
use NoahVet\Reef\RabbitMQ\RabbitMQConnectionFactoryInterface;
use Psr\Log\LoggerInterface;

class ReefMQConsumerFactory implements ReefMQConsumerFactoryInterface
{
    public function __construct(
        private readonly ReefAMQPMessageHandlerInterface $messageHandler,
        private readonly RabbitMQConnectionFactoryInterface $rabbitMQConnectionFactory,
        private readonly LoggerInterface $reefConsumerLogger,
        private readonly string $reefAppName,
    ) {
    }

    public function createConsumer(): ReefMQConsumerInterface
    {
        return new ReefMQConsumer(
            $this->rabbitMQConnectionFactory->get(),
            $this->messageHandler,
            $this->reefConsumerLogger,
            $this->reefAppName,
        );
    }
}
