<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Runtime\Normalizer;

use Symfony\Component\Validator\Constraint;

trait ValidatorTrait
{
    protected function validate(array $data, Constraint $constraint): void
    {
        $validator = \Symfony\Component\Validator\Validation::createValidator();
        $violations = $validator->validate($data, $constraint);
        if (0 < $violations->count()) {
            throw new ValidationException($violations);
        }
    }
}
