<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class VeterinaryEstablishmentServiceDiscountRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDiscountRequest' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDiscountRequest' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceDiscountRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('accountingCode', $data)) {
            $object->setAccountingCode($data['accountingCode']);
            unset($data['accountingCode']);
        }
        if (\array_key_exists('amount', $data)) {
            $object->setAmount($data['amount']);
            unset($data['amount']);
        }
        if (\array_key_exists('entitled', $data)) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        }
        if (\array_key_exists('internalCommentary', $data) && null !== $data['internalCommentary']) {
            $object->setInternalCommentary($data['internalCommentary']);
            unset($data['internalCommentary']);
        } elseif (\array_key_exists('internalCommentary', $data) && null === $data['internalCommentary']) {
            $object->setInternalCommentary(null);
        }
        if (\array_key_exists('veterinaryEstablishmentServicePeriod', $data)) {
            $object->setVeterinaryEstablishmentServicePeriod($this->denormalizer->denormalize($data['veterinaryEstablishmentServicePeriod'], 'NoahVet\\Reef\\Jane\\Model\\IdRequest', 'json', $context));
            unset($data['veterinaryEstablishmentServicePeriod']);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['accountingCode'] = $object->getAccountingCode();
        $data['amount'] = $object->getAmount();
        $data['entitled'] = $object->getEntitled();
        $data['internalCommentary'] = $object->getInternalCommentary();
        $data['veterinaryEstablishmentServicePeriod'] = $this->normalizer->normalize($object->getVeterinaryEstablishmentServicePeriod(), 'json', $context);
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDiscountRequest' => false];
    }
}
