<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class VeterinaryEstablishmentServiceDeliveryResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDeliveryResponse' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDeliveryResponse' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceDeliveryResponse();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('accountingCode', $data) && null !== $data['accountingCode']) {
            $object->setAccountingCode($data['accountingCode']);
            unset($data['accountingCode']);
        } elseif (\array_key_exists('accountingCode', $data) && null === $data['accountingCode']) {
            $object->setAccountingCode(null);
        }
        if (\array_key_exists('completionDate', $data) && null !== $data['completionDate']) {
            $object->setCompletionDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['completionDate']));
            unset($data['completionDate']);
        } elseif (\array_key_exists('completionDate', $data) && null === $data['completionDate']) {
            $object->setCompletionDate(null);
        }
        if (\array_key_exists('internalCommentary', $data) && null !== $data['internalCommentary']) {
            $object->setInternalCommentary($data['internalCommentary']);
            unset($data['internalCommentary']);
        } elseif (\array_key_exists('internalCommentary', $data) && null === $data['internalCommentary']) {
            $object->setInternalCommentary(null);
        }
        if (\array_key_exists('invoiceDate', $data) && null !== $data['invoiceDate']) {
            $object->setInvoiceDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['invoiceDate']));
            unset($data['invoiceDate']);
        } elseif (\array_key_exists('invoiceDate', $data) && null === $data['invoiceDate']) {
            $object->setInvoiceDate(null);
        }
        if (\array_key_exists('longDescription', $data) && null !== $data['longDescription']) {
            $object->setLongDescription($data['longDescription']);
            unset($data['longDescription']);
        } elseif (\array_key_exists('longDescription', $data) && null === $data['longDescription']) {
            $object->setLongDescription(null);
        }
        if (\array_key_exists('paymentMethod', $data)) {
            $object->setPaymentMethod($data['paymentMethod']);
            unset($data['paymentMethod']);
        }
        if (\array_key_exists('serviceDeliveryOption', $data)) {
            $object->setServiceDeliveryOption($this->denormalizer->denormalize($data['serviceDeliveryOption'], 'NoahVet\\Reef\\Jane\\Model\\IdResponse', 'json', $context));
            unset($data['serviceDeliveryOption']);
        }
        if (\array_key_exists('shouldGenerateInvoice', $data)) {
            $object->setShouldGenerateInvoice($data['shouldGenerateInvoice']);
            unset($data['shouldGenerateInvoice']);
        }
        if (\array_key_exists('specificBillingAccount', $data) && null !== $data['specificBillingAccount']) {
            $object->setSpecificBillingAccount($this->denormalizer->denormalize($data['specificBillingAccount'], 'NoahVet\\Reef\\Jane\\Model\\NullableIdResponse', 'json', $context));
            unset($data['specificBillingAccount']);
        } elseif (\array_key_exists('specificBillingAccount', $data) && null === $data['specificBillingAccount']) {
            $object->setSpecificBillingAccount(null);
        }
        if (\array_key_exists('specificVeterinaryGroup', $data) && null !== $data['specificVeterinaryGroup']) {
            $object->setSpecificVeterinaryGroup($this->denormalizer->denormalize($data['specificVeterinaryGroup'], 'NoahVet\\Reef\\Jane\\Model\\NullableIdResponse', 'json', $context));
            unset($data['specificVeterinaryGroup']);
        } elseif (\array_key_exists('specificVeterinaryGroup', $data) && null === $data['specificVeterinaryGroup']) {
            $object->setSpecificVeterinaryGroup(null);
        }
        if (\array_key_exists('unitPriceWithoutVat', $data)) {
            $object->setUnitPriceWithoutVat($data['unitPriceWithoutVat']);
            unset($data['unitPriceWithoutVat']);
        }
        if (\array_key_exists('unitPriceWithVat', $data)) {
            $object->setUnitPriceWithVat($data['unitPriceWithVat']);
            unset($data['unitPriceWithVat']);
        }
        if (\array_key_exists('veterinaryEstablishment', $data)) {
            $object->setVeterinaryEstablishment($this->denormalizer->denormalize($data['veterinaryEstablishment'], 'NoahVet\\Reef\\Jane\\Model\\IdResponse', 'json', $context));
            unset($data['veterinaryEstablishment']);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['id'] = $object->getId();
        $data['createdDate'] = $object->getCreatedDate()->format('Y-m-d\\TH:i:sP');
        $data['updatedDate'] = $object->getUpdatedDate()->format('Y-m-d\\TH:i:sP');
        $data['accountingCode'] = $object->getAccountingCode();
        $data['completionDate'] = $object->getCompletionDate()->format('Y-m-d\\TH:i:sP');
        $data['internalCommentary'] = $object->getInternalCommentary();
        $data['invoiceDate'] = $object->getInvoiceDate()->format('Y-m-d\\TH:i:sP');
        $data['longDescription'] = $object->getLongDescription();
        $data['paymentMethod'] = $object->getPaymentMethod();
        $data['serviceDeliveryOption'] = $this->normalizer->normalize($object->getServiceDeliveryOption(), 'json', $context);
        $data['shouldGenerateInvoice'] = $object->getShouldGenerateInvoice();
        $data['specificBillingAccount'] = $this->normalizer->normalize($object->getSpecificBillingAccount(), 'json', $context);
        $data['specificVeterinaryGroup'] = $this->normalizer->normalize($object->getSpecificVeterinaryGroup(), 'json', $context);
        $data['unitPriceWithoutVat'] = $object->getUnitPriceWithoutVat();
        $data['unitPriceWithVat'] = $object->getUnitPriceWithVat();
        $data['veterinaryEstablishment'] = $this->normalizer->normalize($object->getVeterinaryEstablishment(), 'json', $context);
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDeliveryResponse' => false];
    }
}
