<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class VeterinaryEstablishmentResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentResponse' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentResponse' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentResponse();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('addresses', $data)) {
            $values = [];
            foreach ($data['addresses'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentAddressResponse', 'json', $context);
            }
            $object->setAddresses($values);
            unset($data['addresses']);
        }
        if (\array_key_exists('banner', $data) && null !== $data['banner']) {
            $object->setBanner($this->denormalizer->denormalize($data['banner'], 'NoahVet\\Reef\\Jane\\Model\\NullableIdResponse', 'json', $context));
            unset($data['banner']);
        } elseif (\array_key_exists('banner', $data) && null === $data['banner']) {
            $object->setBanner(null);
        }
        if (\array_key_exists('customName', $data) && null !== $data['customName']) {
            $object->setCustomName($data['customName']);
            unset($data['customName']);
        } elseif (\array_key_exists('customName', $data) && null === $data['customName']) {
            $object->setCustomName(null);
        }
        if (\array_key_exists('entryNumber', $data) && null !== $data['entryNumber']) {
            $object->setEntryNumber($data['entryNumber']);
            unset($data['entryNumber']);
        } elseif (\array_key_exists('entryNumber', $data) && null === $data['entryNumber']) {
            $object->setEntryNumber(null);
        }
        if (\array_key_exists('internalCommentary', $data) && null !== $data['internalCommentary']) {
            $object->setInternalCommentary($data['internalCommentary']);
            unset($data['internalCommentary']);
        } elseif (\array_key_exists('internalCommentary', $data) && null === $data['internalCommentary']) {
            $object->setInternalCommentary(null);
        }
        if (\array_key_exists('legalStructure', $data)) {
            $object->setLegalStructure($this->denormalizer->denormalize($data['legalStructure'], 'NoahVet\\Reef\\Jane\\Model\\IdResponse', 'json', $context));
            unset($data['legalStructure']);
        }
        if (\array_key_exists('logo', $data) && null !== $data['logo']) {
            $object->setLogo($this->denormalizer->denormalize($data['logo'], 'NoahVet\\Reef\\Jane\\Model\\NullableIdResponse', 'json', $context));
            unset($data['logo']);
        } elseif (\array_key_exists('logo', $data) && null === $data['logo']) {
            $object->setLogo(null);
        }
        if (\array_key_exists('longDescription', $data) && null !== $data['longDescription']) {
            $object->setLongDescription($data['longDescription']);
            unset($data['longDescription']);
        } elseif (\array_key_exists('longDescription', $data) && null === $data['longDescription']) {
            $object->setLongDescription(null);
        }
        if (\array_key_exists('mainAddress', $data) && null !== $data['mainAddress']) {
            $object->setMainAddress($this->denormalizer->denormalize($data['mainAddress'], 'NoahVet\\Reef\\Jane\\Model\\NullableIdResponse', 'json', $context));
            unset($data['mainAddress']);
        } elseif (\array_key_exists('mainAddress', $data) && null === $data['mainAddress']) {
            $object->setMainAddress(null);
        }
        if (\array_key_exists('mainBillingAccount', $data) && null !== $data['mainBillingAccount']) {
            $object->setMainBillingAccount($this->denormalizer->denormalize($data['mainBillingAccount'], 'NoahVet\\Reef\\Jane\\Model\\NullableIdResponse', 'json', $context));
            unset($data['mainBillingAccount']);
        } elseif (\array_key_exists('mainBillingAccount', $data) && null === $data['mainBillingAccount']) {
            $object->setMainBillingAccount(null);
        }
        if (\array_key_exists('name', $data)) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        if (\array_key_exists('personalisedMention', $data) && null !== $data['personalisedMention']) {
            $object->setPersonalisedMention($data['personalisedMention']);
            unset($data['personalisedMention']);
        } elseif (\array_key_exists('personalisedMention', $data) && null === $data['personalisedMention']) {
            $object->setPersonalisedMention(null);
        }
        if (\array_key_exists('pictures', $data) && null !== $data['pictures']) {
            $values_1 = [];
            foreach ($data['pictures'] as $value_1) {
                $values_1[] = $this->denormalizer->denormalize($value_1, 'NoahVet\\Reef\\Jane\\Model\\IdResponse', 'json', $context);
            }
            $object->setPictures($values_1);
            unset($data['pictures']);
        } elseif (\array_key_exists('pictures', $data) && null === $data['pictures']) {
            $object->setPictures(null);
        }
        if (\array_key_exists('privilegedCode', $data)) {
            $object->setPrivilegedCode($data['privilegedCode']);
            unset($data['privilegedCode']);
        }
        if (\array_key_exists('schedule', $data)) {
            $object->setSchedule($this->denormalizer->denormalize($data['schedule'], 'NoahVet\\Reef\\Jane\\Model\\ScheduleResponse', 'json', $context));
            unset($data['schedule']);
        }
        if (\array_key_exists('serviceVatCategory', $data)) {
            $object->setServiceVatCategory($data['serviceVatCategory']);
            unset($data['serviceVatCategory']);
        }
        if (\array_key_exists('shortDescription', $data) && null !== $data['shortDescription']) {
            $object->setShortDescription($data['shortDescription']);
            unset($data['shortDescription']);
        } elseif (\array_key_exists('shortDescription', $data) && null === $data['shortDescription']) {
            $object->setShortDescription(null);
        }
        if (\array_key_exists('type', $data)) {
            $object->setType($data['type']);
            unset($data['type']);
        }
        if (\array_key_exists('veterinaryEstablishmentLabellings', $data)) {
            $values_2 = [];
            foreach ($data['veterinaryEstablishmentLabellings'] as $value_2) {
                $values_2[] = $this->denormalizer->denormalize($value_2, 'NoahVet\\Reef\\Jane\\Model\\IdResponse', 'json', $context);
            }
            $object->setVeterinaryEstablishmentLabellings($values_2);
            unset($data['veterinaryEstablishmentLabellings']);
        }
        foreach ($data as $key => $value_3) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_3;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['id'] = $object->getId();
        $data['createdDate'] = $object->getCreatedDate()->format('Y-m-d\\TH:i:sP');
        $data['updatedDate'] = $object->getUpdatedDate()->format('Y-m-d\\TH:i:sP');
        if ($object->isInitialized('addresses') && null !== $object->getAddresses()) {
            $values = [];
            foreach ($object->getAddresses() as $value) {
                $values[] = $this->normalizer->normalize($value, 'json', $context);
            }
            $data['addresses'] = $values;
        }
        $data['banner'] = $this->normalizer->normalize($object->getBanner(), 'json', $context);
        $data['customName'] = $object->getCustomName();
        $data['entryNumber'] = $object->getEntryNumber();
        $data['internalCommentary'] = $object->getInternalCommentary();
        $data['legalStructure'] = $this->normalizer->normalize($object->getLegalStructure(), 'json', $context);
        $data['logo'] = $this->normalizer->normalize($object->getLogo(), 'json', $context);
        $data['longDescription'] = $object->getLongDescription();
        $data['mainAddress'] = $this->normalizer->normalize($object->getMainAddress(), 'json', $context);
        $data['mainBillingAccount'] = $this->normalizer->normalize($object->getMainBillingAccount(), 'json', $context);
        $data['name'] = $object->getName();
        $data['personalisedMention'] = $object->getPersonalisedMention();
        $values_1 = [];
        foreach ($object->getPictures() as $value_1) {
            $values_1[] = $this->normalizer->normalize($value_1, 'json', $context);
        }
        $data['pictures'] = $values_1;
        $data['privilegedCode'] = $object->getPrivilegedCode();
        $data['schedule'] = $this->normalizer->normalize($object->getSchedule(), 'json', $context);
        $data['serviceVatCategory'] = $object->getServiceVatCategory();
        $data['shortDescription'] = $object->getShortDescription();
        $data['type'] = $object->getType();
        $values_2 = [];
        foreach ($object->getVeterinaryEstablishmentLabellings() as $value_2) {
            $values_2[] = $this->normalizer->normalize($value_2, 'json', $context);
        }
        $data['veterinaryEstablishmentLabellings'] = $values_2;
        foreach ($object as $key => $value_3) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value_3;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentResponse' => false];
    }
}
