<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class V1CustomerProfilesIdPatchBodyNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchBody' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchBody' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchBody();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('billingContact', $data) && null !== $data['billingContact']) {
            $object->setBillingContact($this->denormalizer->denormalize($data['billingContact'], 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchBodyBillingContact', 'json', $context));
            unset($data['billingContact']);
        } elseif (\array_key_exists('billingContact', $data) && null === $data['billingContact']) {
            $object->setBillingContact(null);
        }
        if (\array_key_exists('birthDate', $data) && null !== $data['birthDate']) {
            $object->setBirthDate(\DateTime::createFromFormat('Y-m-d', $data['birthDate'])->setTime(0, 0, 0));
            unset($data['birthDate']);
        } elseif (\array_key_exists('birthDate', $data) && null === $data['birthDate']) {
            $object->setBirthDate(null);
        }
        if (\array_key_exists('birthName', $data) && null !== $data['birthName']) {
            $object->setBirthName($data['birthName']);
            unset($data['birthName']);
        } elseif (\array_key_exists('birthName', $data) && null === $data['birthName']) {
            $object->setBirthName(null);
        }
        if (\array_key_exists('companyDescription', $data) && null !== $data['companyDescription']) {
            $object->setCompanyDescription($data['companyDescription']);
            unset($data['companyDescription']);
        } elseif (\array_key_exists('companyDescription', $data) && null === $data['companyDescription']) {
            $object->setCompanyDescription(null);
        }
        if (\array_key_exists('deliveryContact', $data) && null !== $data['deliveryContact']) {
            $object->setDeliveryContact($this->denormalizer->denormalize($data['deliveryContact'], 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchBodyDeliveryContact', 'json', $context));
            unset($data['deliveryContact']);
        } elseif (\array_key_exists('deliveryContact', $data) && null === $data['deliveryContact']) {
            $object->setDeliveryContact(null);
        }
        if (\array_key_exists('firstname', $data) && null !== $data['firstname']) {
            $object->setFirstname($data['firstname']);
            unset($data['firstname']);
        } elseif (\array_key_exists('firstname', $data) && null === $data['firstname']) {
            $object->setFirstname(null);
        }
        if (\array_key_exists('gender', $data) && null !== $data['gender']) {
            $object->setGender($data['gender']);
            unset($data['gender']);
        } elseif (\array_key_exists('gender', $data) && null === $data['gender']) {
            $object->setGender(null);
        }
        if (\array_key_exists('lastname', $data) && null !== $data['lastname']) {
            $object->setLastname($data['lastname']);
            unset($data['lastname']);
        } elseif (\array_key_exists('lastname', $data) && null === $data['lastname']) {
            $object->setLastname(null);
        }
        if (\array_key_exists('mainContact', $data) && null !== $data['mainContact']) {
            $object->setMainContact($this->denormalizer->denormalize($data['mainContact'], 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchBodyMainContact', 'json', $context));
            unset($data['mainContact']);
        } elseif (\array_key_exists('mainContact', $data) && null === $data['mainContact']) {
            $object->setMainContact(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('billingContact') && null !== $object->getBillingContact()) {
            $data['billingContact'] = $this->normalizer->normalize($object->getBillingContact(), 'json', $context);
        }
        if ($object->isInitialized('birthDate') && null !== $object->getBirthDate()) {
            $data['birthDate'] = $object->getBirthDate()->format('Y-m-d');
        }
        if ($object->isInitialized('birthName') && null !== $object->getBirthName()) {
            $data['birthName'] = $object->getBirthName();
        }
        if ($object->isInitialized('companyDescription') && null !== $object->getCompanyDescription()) {
            $data['companyDescription'] = $object->getCompanyDescription();
        }
        if ($object->isInitialized('deliveryContact') && null !== $object->getDeliveryContact()) {
            $data['deliveryContact'] = $this->normalizer->normalize($object->getDeliveryContact(), 'json', $context);
        }
        if ($object->isInitialized('firstname') && null !== $object->getFirstname()) {
            $data['firstname'] = $object->getFirstname();
        }
        if ($object->isInitialized('gender') && null !== $object->getGender()) {
            $data['gender'] = $object->getGender();
        }
        if ($object->isInitialized('lastname') && null !== $object->getLastname()) {
            $data['lastname'] = $object->getLastname();
        }
        if ($object->isInitialized('mainContact') && null !== $object->getMainContact()) {
            $data['mainContact'] = $this->normalizer->normalize($object->getMainContact(), 'json', $context);
        }
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchBody' => false];
    }
}
