<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class V1ContactsGetResponse200ItemCompanyDetailNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\V1ContactsGetResponse200ItemCompanyDetail' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\V1ContactsGetResponse200ItemCompanyDetail' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\V1ContactsGetResponse200ItemCompanyDetail();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('legalCode', $data) && null !== $data['legalCode']) {
            $object->setLegalCode($data['legalCode']);
            unset($data['legalCode']);
        } elseif (\array_key_exists('legalCode', $data) && null === $data['legalCode']) {
            $object->setLegalCode(null);
        }
        if (\array_key_exists('name', $data) && null !== $data['name']) {
            $object->setName($data['name']);
            unset($data['name']);
        } elseif (\array_key_exists('name', $data) && null === $data['name']) {
            $object->setName(null);
        }
        if (\array_key_exists('serviceName', $data) && null !== $data['serviceName']) {
            $object->setServiceName($data['serviceName']);
            unset($data['serviceName']);
        } elseif (\array_key_exists('serviceName', $data) && null === $data['serviceName']) {
            $object->setServiceName(null);
        }
        if (\array_key_exists('type', $data) && null !== $data['type']) {
            $object->setType($data['type']);
            unset($data['type']);
        } elseif (\array_key_exists('type', $data) && null === $data['type']) {
            $object->setType(null);
        }
        if (\array_key_exists('vatIntraCommunityNumber', $data) && null !== $data['vatIntraCommunityNumber']) {
            $object->setVatIntraCommunityNumber($data['vatIntraCommunityNumber']);
            unset($data['vatIntraCommunityNumber']);
        } elseif (\array_key_exists('vatIntraCommunityNumber', $data) && null === $data['vatIntraCommunityNumber']) {
            $object->setVatIntraCommunityNumber(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['legalCode'] = $object->getLegalCode();
        $data['name'] = $object->getName();
        $data['serviceName'] = $object->getServiceName();
        $data['type'] = $object->getType();
        $data['vatIntraCommunityNumber'] = $object->getVatIntraCommunityNumber();
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\V1ContactsGetResponse200ItemCompanyDetail' => false];
    }
}
