<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class ServiceDeliveryOptionRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\ServiceDeliveryOptionRequest' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\ServiceDeliveryOptionRequest' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\ServiceDeliveryOptionRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('accountingCode', $data) && null !== $data['accountingCode']) {
            $object->setAccountingCode($data['accountingCode']);
            unset($data['accountingCode']);
        } elseif (\array_key_exists('accountingCode', $data) && null === $data['accountingCode']) {
            $object->setAccountingCode(null);
        }
        if (\array_key_exists('code', $data)) {
            $object->setCode($data['code']);
            unset($data['code']);
        }
        if (\array_key_exists('description', $data)) {
            $object->setDescription($data['description']);
            unset($data['description']);
        }
        if (\array_key_exists('entitled', $data)) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        }
        if (\array_key_exists('invoiceLineEntitledPattern', $data)) {
            $object->setInvoiceLineEntitledPattern($data['invoiceLineEntitledPattern']);
            unset($data['invoiceLineEntitledPattern']);
        }
        if (\array_key_exists('type', $data)) {
            $object->setType($data['type']);
            unset($data['type']);
        }
        if (\array_key_exists('unitPriceWithoutVat', $data)) {
            $object->setUnitPriceWithoutVat($data['unitPriceWithoutVat']);
            unset($data['unitPriceWithoutVat']);
        }
        if (\array_key_exists('veterinaryService', $data)) {
            $object->setVeterinaryService($this->denormalizer->denormalize($data['veterinaryService'], 'NoahVet\\Reef\\Jane\\Model\\IdRequest', 'json', $context));
            unset($data['veterinaryService']);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('accountingCode') && null !== $object->getAccountingCode()) {
            $data['accountingCode'] = $object->getAccountingCode();
        }
        $data['code'] = $object->getCode();
        $data['description'] = $object->getDescription();
        $data['entitled'] = $object->getEntitled();
        $data['invoiceLineEntitledPattern'] = $object->getInvoiceLineEntitledPattern();
        $data['type'] = $object->getType();
        $data['unitPriceWithoutVat'] = $object->getUnitPriceWithoutVat();
        $data['veterinaryService'] = $this->normalizer->normalize($object->getVeterinaryService(), 'json', $context);
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\ServiceDeliveryOptionRequest' => false];
    }
}
