<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class SchemasVeterinaryEstablishmentServiceDeliveryRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceDeliveryRequest' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceDeliveryRequest' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceDeliveryRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('accountingCode', $data) && null !== $data['accountingCode']) {
            $object->setAccountingCode($data['accountingCode']);
            unset($data['accountingCode']);
        } elseif (\array_key_exists('accountingCode', $data) && null === $data['accountingCode']) {
            $object->setAccountingCode(null);
        }
        if (\array_key_exists('completionDate', $data) && null !== $data['completionDate']) {
            $object->setCompletionDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['completionDate']));
            unset($data['completionDate']);
        } elseif (\array_key_exists('completionDate', $data) && null === $data['completionDate']) {
            $object->setCompletionDate(null);
        }
        if (\array_key_exists('internalCommentary', $data) && null !== $data['internalCommentary']) {
            $object->setInternalCommentary($data['internalCommentary']);
            unset($data['internalCommentary']);
        } elseif (\array_key_exists('internalCommentary', $data) && null === $data['internalCommentary']) {
            $object->setInternalCommentary(null);
        }
        if (\array_key_exists('invoiceDate', $data) && null !== $data['invoiceDate']) {
            $object->setInvoiceDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['invoiceDate']));
            unset($data['invoiceDate']);
        } elseif (\array_key_exists('invoiceDate', $data) && null === $data['invoiceDate']) {
            $object->setInvoiceDate(null);
        }
        if (\array_key_exists('longDescription', $data) && null !== $data['longDescription']) {
            $object->setLongDescription($data['longDescription']);
            unset($data['longDescription']);
        } elseif (\array_key_exists('longDescription', $data) && null === $data['longDescription']) {
            $object->setLongDescription(null);
        }
        if (\array_key_exists('paymentMethod', $data) && null !== $data['paymentMethod']) {
            $object->setPaymentMethod($data['paymentMethod']);
            unset($data['paymentMethod']);
        } elseif (\array_key_exists('paymentMethod', $data) && null === $data['paymentMethod']) {
            $object->setPaymentMethod(null);
        }
        if (\array_key_exists('shouldGenerateInvoice', $data) && null !== $data['shouldGenerateInvoice']) {
            $object->setShouldGenerateInvoice($data['shouldGenerateInvoice']);
            unset($data['shouldGenerateInvoice']);
        } elseif (\array_key_exists('shouldGenerateInvoice', $data) && null === $data['shouldGenerateInvoice']) {
            $object->setShouldGenerateInvoice(null);
        }
        if (\array_key_exists('specificBillingAccount', $data) && null !== $data['specificBillingAccount']) {
            $object->setSpecificBillingAccount($this->denormalizer->denormalize($data['specificBillingAccount'], 'NoahVet\\Reef\\Jane\\Model\\NullableIdRequest', 'json', $context));
            unset($data['specificBillingAccount']);
        } elseif (\array_key_exists('specificBillingAccount', $data) && null === $data['specificBillingAccount']) {
            $object->setSpecificBillingAccount(null);
        }
        if (\array_key_exists('specificVeterinaryGroup', $data) && null !== $data['specificVeterinaryGroup']) {
            $object->setSpecificVeterinaryGroup($this->denormalizer->denormalize($data['specificVeterinaryGroup'], 'NoahVet\\Reef\\Jane\\Model\\NullableIdRequest', 'json', $context));
            unset($data['specificVeterinaryGroup']);
        } elseif (\array_key_exists('specificVeterinaryGroup', $data) && null === $data['specificVeterinaryGroup']) {
            $object->setSpecificVeterinaryGroup(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('accountingCode') && null !== $object->getAccountingCode()) {
            $data['accountingCode'] = $object->getAccountingCode();
        }
        if ($object->isInitialized('completionDate') && null !== $object->getCompletionDate()) {
            $data['completionDate'] = $object->getCompletionDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('internalCommentary') && null !== $object->getInternalCommentary()) {
            $data['internalCommentary'] = $object->getInternalCommentary();
        }
        if ($object->isInitialized('invoiceDate') && null !== $object->getInvoiceDate()) {
            $data['invoiceDate'] = $object->getInvoiceDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('longDescription') && null !== $object->getLongDescription()) {
            $data['longDescription'] = $object->getLongDescription();
        }
        if ($object->isInitialized('paymentMethod') && null !== $object->getPaymentMethod()) {
            $data['paymentMethod'] = $object->getPaymentMethod();
        }
        if ($object->isInitialized('shouldGenerateInvoice') && null !== $object->getShouldGenerateInvoice()) {
            $data['shouldGenerateInvoice'] = $object->getShouldGenerateInvoice();
        }
        if ($object->isInitialized('specificBillingAccount') && null !== $object->getSpecificBillingAccount()) {
            $data['specificBillingAccount'] = $this->normalizer->normalize($object->getSpecificBillingAccount(), 'json', $context);
        }
        if ($object->isInitialized('specificVeterinaryGroup') && null !== $object->getSpecificVeterinaryGroup()) {
            $data['specificVeterinaryGroup'] = $this->normalizer->normalize($object->getSpecificVeterinaryGroup(), 'json', $context);
        }
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceDeliveryRequest' => false];
    }
}
