<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class SchemasVeterinaryEstablishmentActivityRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentActivityRequest' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentActivityRequest' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentActivityRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('caninePercent', $data) && null !== $data['caninePercent']) {
            $object->setCaninePercent($data['caninePercent']);
            unset($data['caninePercent']);
        } elseif (\array_key_exists('caninePercent', $data) && null === $data['caninePercent']) {
            $object->setCaninePercent(null);
        }
        if (\array_key_exists('equinePercent', $data) && null !== $data['equinePercent']) {
            $object->setEquinePercent($data['equinePercent']);
            unset($data['equinePercent']);
        } elseif (\array_key_exists('equinePercent', $data) && null === $data['equinePercent']) {
            $object->setEquinePercent(null);
        }
        if (\array_key_exists('ruralPercent', $data) && null !== $data['ruralPercent']) {
            $object->setRuralPercent($data['ruralPercent']);
            unset($data['ruralPercent']);
        } elseif (\array_key_exists('ruralPercent', $data) && null === $data['ruralPercent']) {
            $object->setRuralPercent(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('caninePercent') && null !== $object->getCaninePercent()) {
            $data['caninePercent'] = $object->getCaninePercent();
        }
        if ($object->isInitialized('equinePercent') && null !== $object->getEquinePercent()) {
            $data['equinePercent'] = $object->getEquinePercent();
        }
        if ($object->isInitialized('ruralPercent') && null !== $object->getRuralPercent()) {
            $data['ruralPercent'] = $object->getRuralPercent();
        }
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentActivityRequest' => false];
    }
}
