<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class SchemasBillingAccountRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\SchemasBillingAccountRequest' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\SchemasBillingAccountRequest' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\SchemasBillingAccountRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('bicSwift', $data) && null !== $data['bicSwift']) {
            $object->setBicSwift($data['bicSwift']);
            unset($data['bicSwift']);
        } elseif (\array_key_exists('bicSwift', $data) && null === $data['bicSwift']) {
            $object->setBicSwift(null);
        }
        if (\array_key_exists('entitled', $data) && null !== $data['entitled']) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        } elseif (\array_key_exists('entitled', $data) && null === $data['entitled']) {
            $object->setEntitled(null);
        }
        if (\array_key_exists('file', $data) && null !== $data['file']) {
            $object->setFile($this->denormalizer->denormalize($data['file'], 'NoahVet\\Reef\\Jane\\Model\\NullableIdRequest', 'json', $context));
            unset($data['file']);
        } elseif (\array_key_exists('file', $data) && null === $data['file']) {
            $object->setFile(null);
        }
        if (\array_key_exists('iban', $data) && null !== $data['iban']) {
            $object->setIban($data['iban']);
            unset($data['iban']);
        } elseif (\array_key_exists('iban', $data) && null === $data['iban']) {
            $object->setIban(null);
        }
        if (\array_key_exists('identityName', $data) && null !== $data['identityName']) {
            $object->setIdentityName($data['identityName']);
            unset($data['identityName']);
        } elseif (\array_key_exists('identityName', $data) && null === $data['identityName']) {
            $object->setIdentityName(null);
        }
        if (\array_key_exists('status', $data) && null !== $data['status']) {
            $object->setStatus($data['status']);
            unset($data['status']);
        } elseif (\array_key_exists('status', $data) && null === $data['status']) {
            $object->setStatus(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('bicSwift') && null !== $object->getBicSwift()) {
            $data['bicSwift'] = $object->getBicSwift();
        }
        if ($object->isInitialized('entitled') && null !== $object->getEntitled()) {
            $data['entitled'] = $object->getEntitled();
        }
        if ($object->isInitialized('file') && null !== $object->getFile()) {
            $data['file'] = $this->normalizer->normalize($object->getFile(), 'json', $context);
        }
        if ($object->isInitialized('iban') && null !== $object->getIban()) {
            $data['iban'] = $object->getIban();
        }
        if ($object->isInitialized('identityName') && null !== $object->getIdentityName()) {
            $data['identityName'] = $object->getIdentityName();
        }
        if ($object->isInitialized('status') && null !== $object->getStatus()) {
            $data['status'] = $object->getStatus();
        }
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\SchemasBillingAccountRequest' => false];
    }
}
