<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class PrincipalPhoneNumberNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\PrincipalPhoneNumber' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\PrincipalPhoneNumber' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\PrincipalPhoneNumber();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('phoneNumber', $data)) {
            $object->setPhoneNumber($data['phoneNumber']);
            unset($data['phoneNumber']);
        }
        if (\array_key_exists('validated', $data) && null !== $data['validated']) {
            $object->setValidated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['validated']));
            unset($data['validated']);
        } elseif (\array_key_exists('validated', $data) && null === $data['validated']) {
            $object->setValidated(null);
        }
        if (\array_key_exists('validationMethod', $data) && null !== $data['validationMethod']) {
            $value = $data['validationMethod'];
            if (\is_array($data['validationMethod'])) {
                $value = $this->denormalizer->denormalize($data['validationMethod'], 'NoahVet\\Reef\\Jane\\Model\\PhoneValidationMethodEnum', 'json', $context);
            }
            $object->setValidationMethod($value);
            unset($data['validationMethod']);
        } elseif (\array_key_exists('validationMethod', $data) && null === $data['validationMethod']) {
            $object->setValidationMethod(null);
        }
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('phoneNumber') && null !== $object->getPhoneNumber()) {
            $data['phoneNumber'] = $object->getPhoneNumber();
        }
        if ($object->isInitialized('validated') && null !== $object->getValidated()) {
            $data['validated'] = $object->getValidated()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('validationMethod') && null !== $object->getValidationMethod()) {
            $value = $object->getValidationMethod();
            if (\is_object($object->getValidationMethod())) {
                $value = $this->normalizer->normalize($object->getValidationMethod(), 'json', $context);
            }
            $data['validationMethod'] = $value;
        }
        foreach ($object as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value_1;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\PrincipalPhoneNumber' => false];
    }
}
