<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class JaneObjectNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    protected $normalizers = ['NoahVet\\Reef\\Jane\\Model\\NullableIdResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\NullableIdResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\IdResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\IdResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\BillingAccountResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\BillingAccountResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\NullableIdRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\NullableIdRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\IdRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\IdRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\BillingAccountRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\BillingAccountRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasBillingAccountResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasBillingAccountResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasBillingAccountResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\ComponentsSchemasBillingAccountResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasBillingAccountRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasBillingAccountRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\BillingAccountResponseComponentsSchemasBillingAccountResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\BillingAccountResponseComponentsSchemasBillingAccountResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\YousignSignatureRequestResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\YousignSignatureRequestResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\MandateResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\MandateResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasMandateResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasMandateResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ContractResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\ContractResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ContractRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\ContractRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ContractDocumentResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\ContractDocumentResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\InvitationResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\InvitationResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentUserInvitationRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentUserInvitationRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentUserInvitationResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentUserInvitationResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentUserInvitationConfirmationRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentUserInvitationConfirmationRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentUserInvitationConfirmationResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentUserInvitationConfirmationResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupUserInvitationRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryGroupUserInvitationRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupUserInvitationResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryGroupUserInvitationResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupUserInvitationConfirmationRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryGroupUserInvitationConfirmationRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupUserInvitationConfirmationResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryGroupUserInvitationConfirmationResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\InvoiceAddressResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\InvoiceAddressResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\CreditNoteResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\CreditNoteResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\CreditNoteResponseAccountingMovement' => 'NoahVet\\Reef\\Jane\\Normalizer\\CreditNoteResponseAccountingMovementNormalizer', 'NoahVet\\Reef\\Jane\\Model\\CreditNoteResponseBankAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\CreditNoteResponseBankAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\CreditNoteResponseCreditNoteLinesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\CreditNoteResponseCreditNoteLinesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\CreditNoteResponseDeliveryInformation' => 'NoahVet\\Reef\\Jane\\Normalizer\\CreditNoteResponseDeliveryInformationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\CreditNoteResponseReceiverInformation' => 'NoahVet\\Reef\\Jane\\Normalizer\\CreditNoteResponseReceiverInformationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\CreditNoteResponseSenderInformation' => 'NoahVet\\Reef\\Jane\\Normalizer\\CreditNoteResponseSenderInformationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\InvoiceAddressRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\InvoiceAddressRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\CreditNoteRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\CreditNoteRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\CreditNoteRequestDeliveryInformation' => 'NoahVet\\Reef\\Jane\\Normalizer\\CreditNoteRequestDeliveryInformationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\CreditNoteRequestReceiverInformation' => 'NoahVet\\Reef\\Jane\\Normalizer\\CreditNoteRequestReceiverInformationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\InvoiceResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItemAccountingMovement' => 'NoahVet\\Reef\\Jane\\Normalizer\\InvoiceResponseItemAccountingMovementNormalizer', 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItemBankAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\InvoiceResponseItemBankAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItemDeliveryInformation' => 'NoahVet\\Reef\\Jane\\Normalizer\\InvoiceResponseItemDeliveryInformationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItemInvoiceLinesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\InvoiceResponseItemInvoiceLinesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItemReceiverInformation' => 'NoahVet\\Reef\\Jane\\Normalizer\\InvoiceResponseItemReceiverInformationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItemSenderInformation' => 'NoahVet\\Reef\\Jane\\Normalizer\\InvoiceResponseItemSenderInformationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ServiceDeliveryInvoiceRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\ServiceDeliveryInvoiceRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ServiceDeliveryInvoiceResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\ServiceDeliveryInvoiceResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\CoordinateResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\CoordinateResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PostalAddressResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\PostalAddressResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\LegalStructureResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\LegalStructureResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\CoordinateRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\CoordinateRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PostalAddressRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\PostalAddressRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\LegalStructureRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\LegalStructureRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasLegalStructureResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasLegalStructureResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasLegalStructureResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\ComponentsSchemasLegalStructureResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasPostalAddressRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasPostalAddressRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasLegalStructureRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasLegalStructureRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\LegalStructureResponseComponentsSchemasLegalStructureResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\LegalStructureResponseComponentsSchemasLegalStructureResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SearchRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\SearchRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\LegalStructureSearchResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\LegalStructureSearchResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\RequiredMandateResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\RequiredMandateResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\RequiredMandateResponseItemFilledMandate' => 'NoahVet\\Reef\\Jane\\Normalizer\\RequiredMandateResponseItemFilledMandateNormalizer', 'NoahVet\\Reef\\Jane\\Model\\RequiredMandateRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\RequiredMandateRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasRequiredMandateResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasRequiredMandateResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasRequiredMandateResponseFilledMandate' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasRequiredMandateResponseFilledMandateNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasRequiredMandateResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\ComponentsSchemasRequiredMandateResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasRequiredMandateResponseFilledMandate' => 'NoahVet\\Reef\\Jane\\Normalizer\\ComponentsSchemasRequiredMandateResponseFilledMandateNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ManufacturerResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\ManufacturerResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ManufacturerResponseItemBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\ManufacturerResponseItemBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ManufacturerResponseItemLegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\ManufacturerResponseItemLegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ManufacturerResponseItemLogo' => 'NoahVet\\Reef\\Jane\\Normalizer\\ManufacturerResponseItemLogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ManufacturerResponseItemPicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\ManufacturerResponseItemPicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\DocumentResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\DocumentResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\DocumentRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\DocumentRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasDocumentResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasDocumentResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ImageResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\ImageResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ImageRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\ImageRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasImageResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasImageResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDeliveryResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentServiceDeliveryResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDeliveryRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentServiceDeliveryRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceDeliveryRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentServiceDeliveryRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ServiceDeliveryOptionResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\ServiceDeliveryOptionResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ServiceDeliveryOptionRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\ServiceDeliveryOptionRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasServiceDeliveryOptionRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasServiceDeliveryOptionRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ManufacturerUserResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\ManufacturerUserResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ManufacturerUserResponseItemManufacturer' => 'NoahVet\\Reef\\Jane\\Normalizer\\ManufacturerUserResponseItemManufacturerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ManufacturerUserResponseItemUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\ManufacturerUserResponseItemUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentUserResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentUserResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentUserResponseItemUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentUserResponseItemUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentUserResponseItemVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentUserResponseItemVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentUserRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentUserRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentUserResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentUserResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentUserRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentUserRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryEstablishmentUserResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\ComponentsSchemasVeterinaryEstablishmentUserResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupUserResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryGroupUserResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupUserResponseItemUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryGroupUserResponseItemUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupUserResponseItemVeterinaryGroup' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryGroupUserResponseItemVeterinaryGroupNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupUserRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryGroupUserRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryGroupUserResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryGroupUserResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryGroupUserRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryGroupUserRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryGroupUserResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\ComponentsSchemasVeterinaryGroupUserResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentAddressResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentAddressResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentAddressResponsePhone' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentAddressResponsePhoneNormalizer', 'NoahVet\\Reef\\Jane\\Model\\OpeningHourResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\OpeningHourResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\OpeningPeriodResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\OpeningPeriodResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ScheduleResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\ScheduleResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\OpeningHourRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\OpeningHourRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\OpeningPeriodRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\OpeningPeriodRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentRequestSchedule' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentRequestScheduleNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentRequestSchedule' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentRequestScheduleNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentAddressRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentAddressRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentAddressRequestPhone' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentAddressRequestPhoneNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentAddressRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentAddressRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentAddressRequestPhone' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentAddressRequestPhoneNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentCreditNoteResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentCreditNoteResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentCreditNoteResponseItemModeration' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentCreditNoteResponseItemModerationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentCreditNoteResponseItemVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentCreditNoteResponseItemVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentCreditNoteRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentCreditNoteRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentCreditNoteRequestModeration' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentCreditNoteRequestModerationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentCreditNoteResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentCreditNoteResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentCreditNoteResponseModeration' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentCreditNoteResponseModerationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentCreditNoteResponseVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentCreditNoteResponseVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentCreditNoteRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentCreditNoteRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryEstablishmentCreditNoteResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\ComponentsSchemasVeterinaryEstablishmentCreditNoteResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryEstablishmentCreditNoteResponseModeration' => 'NoahVet\\Reef\\Jane\\Normalizer\\ComponentsSchemasVeterinaryEstablishmentCreditNoteResponseModerationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentCreditNoteBulkRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentCreditNoteBulkRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentMemberResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentMemberResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentMemberRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentMemberRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentMemberRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentMemberRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentActivityResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentActivityResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentActivityRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentActivityRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentActivityResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentActivityResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentActivityRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentActivityRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryEstablishmentActivityResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\ComponentsSchemasVeterinaryEstablishmentActivityResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentMandateResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentMandateResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentMandateRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentMandateRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentMandateRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentMandateRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServicePeriodResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentServicePeriodResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServicePeriodResponseItemAttributesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentServicePeriodResponseItemAttributesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceSubscriptionResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentServiceSubscriptionResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceSubscriptionResponseItemAttributesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentServiceSubscriptionResponseItemAttributesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceSubscriptionRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentServiceSubscriptionRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceSubscriptionRequestAttributesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentServiceSubscriptionRequestAttributesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceSubscriptionResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentServiceSubscriptionResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceSubscriptionResponseAttributesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentServiceSubscriptionResponseAttributesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceSubscriptionReductionRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentServiceSubscriptionReductionRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceSubscriptionReductionResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentServiceSubscriptionReductionResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceSubscriptionReductionResponseAttributesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentServiceSubscriptionReductionResponseAttributesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceSubscriptionRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentServiceSubscriptionRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceSubscriptionRequestAttributesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentServiceSubscriptionRequestAttributesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponseAttributesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponseAttributesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDiscountResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentServiceDiscountResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDiscountRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentServiceDiscountRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceDiscountResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentServiceDiscountResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceDiscountRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentServiceDiscountRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryEstablishmentServiceDiscountResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\ComponentsSchemasVeterinaryEstablishmentServiceDiscountResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDeliveryDiscountResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentServiceDeliveryDiscountResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDeliveryDiscountRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentServiceDeliveryDiscountRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceDeliveryDiscountResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentServiceDeliveryDiscountResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceDeliveryDiscountRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentServiceDeliveryDiscountRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryEstablishmentServiceDeliveryDiscountResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\ComponentsSchemasVeterinaryEstablishmentServiceDeliveryDiscountResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentLabellingResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentLabellingResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentLabellingRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentLabellingRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentTagResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentTagResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentTagRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryEstablishmentTagRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentTagResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryEstablishmentTagResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryEstablishmentTagResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\ComponentsSchemasVeterinaryEstablishmentTagResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\MetadataResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\MetadataResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryGroupResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\MetadataRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\MetadataRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryGroupRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryGroupRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryGroupRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupMandateResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryGroupMandateResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupMandateRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryGroupMandateRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryGroupMandateRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\SchemasVeterinaryGroupMandateRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryServiceResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryServiceResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryServiceResponseItemBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryServiceResponseItemBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryServiceResponseItemCreditor' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryServiceResponseItemCreditorNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryServiceOptionResponse' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryServiceOptionResponseNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryServiceOptionRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryServiceOptionRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryServiceOptionConfigResponseItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryServiceOptionConfigResponseItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryServiceOptionConfigResponseItemAccountingCodesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryServiceOptionConfigResponseItemAccountingCodesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\VeterinaryServiceOptionConfigResponseItemVeterinaryServiceOption' => 'NoahVet\\Reef\\Jane\\Normalizer\\VeterinaryServiceOptionConfigResponseItemVeterinaryServiceOptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\YouSignContractConfirmationRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\YouSignContractConfirmationRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\YouSignContractConfirmationRequestData' => 'NoahVet\\Reef\\Jane\\Normalizer\\YouSignContractConfirmationRequestDataNormalizer', 'NoahVet\\Reef\\Jane\\Model\\YouSignContractConfirmationRequestDataSignatureRequest' => 'NoahVet\\Reef\\Jane\\Normalizer\\YouSignContractConfirmationRequestDataSignatureRequestNormalizer', 'NoahVet\\Reef\\Jane\\Model\\Client' => 'NoahVet\\Reef\\Jane\\Normalizer\\ClientNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ClientGet' => 'NoahVet\\Reef\\Jane\\Normalizer\\ClientGetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\CountryTypeEnum' => 'NoahVet\\Reef\\Jane\\Normalizer\\CountryTypeEnumNormalizer', 'NoahVet\\Reef\\Jane\\Model\\GrantedPermissionShort' => 'NoahVet\\Reef\\Jane\\Normalizer\\GrantedPermissionShortNormalizer', 'NoahVet\\Reef\\Jane\\Model\\InvitationEmailStatusEnum' => 'NoahVet\\Reef\\Jane\\Normalizer\\InvitationEmailStatusEnumNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PhoneValidationMethodEnum' => 'NoahVet\\Reef\\Jane\\Normalizer\\PhoneValidationMethodEnumNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PolicyResultPolicyResultGet' => 'NoahVet\\Reef\\Jane\\Normalizer\\PolicyResultPolicyResultGetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PolicyResultPolicyResultPost' => 'NoahVet\\Reef\\Jane\\Normalizer\\PolicyResultPolicyResultPostNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PostalAddress' => 'NoahVet\\Reef\\Jane\\Normalizer\\PostalAddressNormalizer', 'NoahVet\\Reef\\Jane\\Model\\Principal' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalPrincipalGet' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalPrincipalGetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalPrincipalPatch' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalPrincipalPatchNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalPrincipalPut' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalPrincipalPutNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalGroup' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalGroupNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalInvitation' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalInvitationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalPhoneNumber' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalPhoneNumberNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalStatusEnum' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalStatusEnumNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalTypeEnum' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalTypeEnumNormalizer', 'NoahVet\\Reef\\Jane\\Model\\Resource' => 'NoahVet\\Reef\\Jane\\Normalizer\\ResourceNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupResourceGroupGet' => 'NoahVet\\Reef\\Jane\\Normalizer\\ResourceGroupResourceGroupGetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupResourceGroupPost' => 'NoahVet\\Reef\\Jane\\Normalizer\\ResourceGroupResourceGroupPostNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupResourceGroupPut' => 'NoahVet\\Reef\\Jane\\Normalizer\\ResourceGroupResourceGroupPutNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ResourceType' => 'NoahVet\\Reef\\Jane\\Normalizer\\ResourceTypeNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ResourceTypeGetshort' => 'NoahVet\\Reef\\Jane\\Normalizer\\ResourceTypeGetshortNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PermissionGrant' => 'NoahVet\\Reef\\Jane\\Normalizer\\PermissionGrantNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PermissionGrantList' => 'NoahVet\\Reef\\Jane\\Normalizer\\PermissionGrantListNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalShort' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalShortNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalGet' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalGetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalGetPhoneNumbersItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalGetPhoneNumbersItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalPut' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalPutNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalPutPhoneNumbersItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalPutPhoneNumbersItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ServicePermission' => 'NoahVet\\Reef\\Jane\\Normalizer\\ServicePermissionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ServiceResource' => 'NoahVet\\Reef\\Jane\\Normalizer\\ServiceResourceNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ServiceExternalResource' => 'NoahVet\\Reef\\Jane\\Normalizer\\ServiceExternalResourceNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ServiceDefinition' => 'NoahVet\\Reef\\Jane\\Normalizer\\ServiceDefinitionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupGet' => 'NoahVet\\Reef\\Jane\\Normalizer\\ResourceGroupGetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupPost' => 'NoahVet\\Reef\\Jane\\Normalizer\\ResourceGroupPostNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupPut' => 'NoahVet\\Reef\\Jane\\Normalizer\\ResourceGroupPutNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsGetResponse200ItemCompanyDetail' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsGetResponse200ItemCompanyDetailNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsGetResponse200ItemCustomerProfile' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsGetResponse200ItemCustomerProfileNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsGetResponse200ItemGeolocation' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsGetResponse200ItemGeolocationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsGetResponse206ItemCompanyDetail' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsGetResponse206ItemCompanyDetailNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsGetResponse206ItemCustomerProfile' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsGetResponse206ItemCustomerProfileNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsGetResponse206ItemGeolocation' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsGetResponse206ItemGeolocationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsPostBodyCompanyDetail' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsPostBodyCompanyDetailNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsPostBodyCustomerProfile' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsPostBodyCustomerProfileNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsPostBodyGeolocation' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsPostBodyGeolocationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsPostResponse201CompanyDetail' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsPostResponse201CompanyDetailNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsPostResponse201CustomerProfile' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsPostResponse201CustomerProfileNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsPostResponse201Geolocation' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsPostResponse201GeolocationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsIdPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsIdPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsIdPatchBodyCompanyDetail' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsIdPatchBodyCompanyDetailNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsIdPatchBodyGeolocation' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsIdPatchBodyGeolocationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsIdPatchResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsIdPatchResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsIdPatchResponse200CompanyDetail' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsIdPatchResponse200CompanyDetailNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsIdPatchResponse200CustomerProfile' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsIdPatchResponse200CustomerProfileNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ContactsIdPatchResponse200Geolocation' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ContactsIdPatchResponse200GeolocationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomersGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomersGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomersGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomersGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomersIdPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomersIdPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomersIdPatchResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomersIdPatchResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse200ItemBillingContact' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesGetResponse200ItemBillingContactNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse200ItemCustomer' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesGetResponse200ItemCustomerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse200ItemDeliveryContact' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesGetResponse200ItemDeliveryContactNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse200ItemMainContact' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesGetResponse200ItemMainContactNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse206ItemBillingContact' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesGetResponse206ItemBillingContactNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse206ItemCustomer' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesGetResponse206ItemCustomerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse206ItemDeliveryContact' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesGetResponse206ItemDeliveryContactNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse206ItemMainContact' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesGetResponse206ItemMainContactNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesPostBodyCustomer' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesPostBodyCustomerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesPostResponse201BillingContact' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesPostResponse201BillingContactNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesPostResponse201Customer' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesPostResponse201CustomerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesPostResponse201DeliveryContact' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesPostResponse201DeliveryContactNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesPostResponse201MainContact' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesPostResponse201MainContactNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesIdPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchBodyBillingContact' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesIdPatchBodyBillingContactNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchBodyDeliveryContact' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesIdPatchBodyDeliveryContactNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchBodyMainContact' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesIdPatchBodyMainContactNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesIdPatchResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchResponse200BillingContact' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesIdPatchResponse200BillingContactNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchResponse200Customer' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesIdPatchResponse200CustomerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchResponse200DeliveryContact' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesIdPatchResponse200DeliveryContactNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchResponse200MainContact' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1CustomerProfilesIdPatchResponse200MainContactNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse200ItemMicrochipsItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsGetResponse200ItemMicrochipsItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse200ItemTattoo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsGetResponse200ItemTattooNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse200ItemSpecie' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsGetResponse200ItemSpecieNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse206ItemMicrochipsItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsGetResponse206ItemMicrochipsItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse206ItemTattoo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsGetResponse206ItemTattooNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse206ItemSpecie' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsGetResponse206ItemSpecieNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostBodyTattoo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsPostBodyTattooNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostBodySpecie' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsPostBodySpecieNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostResponse201MicrochipsItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsPostResponse201MicrochipsItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostResponse201Tattoo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsPostResponse201TattooNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostResponse201Specie' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsPostResponse201SpecieNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsIdPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsIdPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsIdPatchBodyTattoo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsIdPatchBodyTattooNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsIdPatchBodySpecie' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsIdPatchBodySpecieNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsIdPatchResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsIdPatchResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsIdPatchResponse200MicrochipsItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsIdPatchResponse200MicrochipsItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsIdPatchResponse200Tattoo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsIdPatchResponse200TattooNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsIdPatchResponse200Specie' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsIdPatchResponse200SpecieNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedsGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsGetResponse200ItemAliasesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedsGetResponse200ItemAliasesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsGetResponse200ItemSpecie' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedsGetResponse200ItemSpecieNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedsGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsGetResponse206ItemAliasesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedsGetResponse206ItemAliasesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsGetResponse206ItemSpecie' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedsGetResponse206ItemSpecieNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedsPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostBodySpecie' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedsPostBodySpecieNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostBodyTranslations' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedsPostBodyTranslationsNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostBodyTranslationsEnGB' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedsPostBodyTranslationsEnGBNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostBodyTranslationsEnGBAliasesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedsPostBodyTranslationsEnGBAliasesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostBodyTranslationsFrFR' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedsPostBodyTranslationsFrFRNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostBodyTranslationsFrFRAliasesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedsPostBodyTranslationsFrFRAliasesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedsPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostResponse201AliasesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedsPostResponse201AliasesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostResponse201Specie' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedsPostResponse201SpecieNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalLinksGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksGetResponse200ItemExternalRef' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalLinksGetResponse200ItemExternalRefNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksGetResponse200ItemPetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalLinksGetResponse200ItemPetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalLinksGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksGetResponse206ItemExternalRef' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalLinksGetResponse206ItemExternalRefNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksGetResponse206ItemPetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalLinksGetResponse206ItemPetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalLinksPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksPostBodyPetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalLinksPostBodyPetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksPostBodyExternalRef' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalLinksPostBodyExternalRefNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalLinksPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksPostResponse201ExternalRef' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalLinksPostResponse201ExternalRefNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksPostResponse201PetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalLinksPostResponse201PetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalRefsGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalRefsGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalRefsGetResponse200ItemCoveredLocales' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalRefsGetResponse200ItemCoveredLocalesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalRefsGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalRefsGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalRefsGetResponse206ItemCoveredLocales' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalRefsGetResponse206ItemCoveredLocalesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalRefsPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalRefsPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalRefsPostBodyCoveredLocales' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalRefsPostBodyCoveredLocalesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalRefsPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalRefsPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalRefsPostResponse201CoveredLocales' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedExternalRefsPostResponse201CoveredLocalesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedLabellingsGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsGetResponse200ItemPetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedLabellingsGetResponse200ItemPetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsGetResponse200ItemTag' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedLabellingsGetResponse200ItemTagNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedLabellingsGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsGetResponse206ItemPetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedLabellingsGetResponse206ItemPetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsGetResponse206ItemTag' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedLabellingsGetResponse206ItemTagNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedLabellingsPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsPostBodyPetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedLabellingsPostBodyPetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsPostBodyTag' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedLabellingsPostBodyTagNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedLabellingsPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsPostResponse201PetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedLabellingsPostResponse201PetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsPostResponse201Tag' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedLabellingsPostResponse201TagNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedTagsGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedTagsGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedTagsGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedTagsGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedTagsPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedTagsPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedTagsPostBodyTranslations' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedTagsPostBodyTranslationsNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedTagsPostBodyTranslationsEnGB' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedTagsPostBodyTranslationsEnGBNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedTagsPostBodyTranslationsFrFR' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedTagsPostBodyTranslationsFrFRNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedTagsPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetBreedTagsPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetMicrochipsPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetMicrochipsPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetMicrochipsPostBodyPet' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetMicrochipsPostBodyPetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetMicrochipsPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetMicrochipsPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetMicrochipsPostResponse201Pet' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetMicrochipsPostResponse201PetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetProfilesGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetProfilesGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetProfilesGetResponse200ItemPet' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetProfilesGetResponse200ItemPetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetProfilesGetResponse200ItemPetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetProfilesGetResponse200ItemPetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetProfilesGetResponse200ItemProfilePicture' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetProfilesGetResponse200ItemProfilePictureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetProfilesGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetProfilesGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetProfilesGetResponse206ItemPet' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetProfilesGetResponse206ItemPetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetProfilesGetResponse206ItemPetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetProfilesGetResponse206ItemPetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetProfilesGetResponse206ItemProfilePicture' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetProfilesGetResponse206ItemProfilePictureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetCustomerProfilesPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesPostBodyPet' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetCustomerProfilesPostBodyPetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesPostBodyPetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetCustomerProfilesPostBodyPetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesPostBodyProfilePicture' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetCustomerProfilesPostBodyProfilePictureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetCustomerProfilesPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesPostResponse201Pet' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetCustomerProfilesPostResponse201PetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesPostResponse201PetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetCustomerProfilesPostResponse201PetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesPostResponse201ProfilePicture' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetCustomerProfilesPostResponse201ProfilePictureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesIdPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetCustomerProfilesIdPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesIdPatchBodyPetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetCustomerProfilesIdPatchBodyPetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesIdPatchBodyProfilePicture' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetCustomerProfilesIdPatchBodyProfilePictureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesIdPatchResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetCustomerProfilesIdPatchResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesIdPatchResponse200Pet' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetCustomerProfilesIdPatchResponse200PetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesIdPatchResponse200PetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetCustomerProfilesIdPatchResponse200PetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesIdPatchResponse200ProfilePicture' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetCustomerProfilesIdPatchResponse200ProfilePictureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetGhostProfilesPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesPostBodyPet' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetGhostProfilesPostBodyPetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesPostBodyPetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetGhostProfilesPostBodyPetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesPostBodyProfilePicture' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetGhostProfilesPostBodyProfilePictureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetGhostProfilesPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesPostResponse201Pet' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetGhostProfilesPostResponse201PetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesPostResponse201PetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetGhostProfilesPostResponse201PetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesPostResponse201ProfilePicture' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetGhostProfilesPostResponse201ProfilePictureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesIdPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetGhostProfilesIdPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesIdPatchBodyPetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetGhostProfilesIdPatchBodyPetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesIdPatchBodyProfilePicture' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetGhostProfilesIdPatchBodyProfilePictureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesIdPatchResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetGhostProfilesIdPatchResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesIdPatchResponse200Pet' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetGhostProfilesIdPatchResponse200PetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesIdPatchResponse200PetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetGhostProfilesIdPatchResponse200PetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesIdPatchResponse200ProfilePicture' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetGhostProfilesIdPatchResponse200ProfilePictureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPatientProfilesPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesPostBodyPet' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPatientProfilesPostBodyPetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesPostBodyPetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPatientProfilesPostBodyPetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesPostBodyProfilePicture' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPatientProfilesPostBodyProfilePictureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPatientProfilesPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesPostResponse201Pet' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPatientProfilesPostResponse201PetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesPostResponse201PetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPatientProfilesPostResponse201PetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesPostResponse201ProfilePicture' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPatientProfilesPostResponse201ProfilePictureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesIdPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPatientProfilesIdPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesIdPatchBodyPetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPatientProfilesIdPatchBodyPetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesIdPatchBodyProfilePicture' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPatientProfilesIdPatchBodyProfilePictureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesIdPatchResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPatientProfilesIdPatchResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesIdPatchResponse200Pet' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPatientProfilesIdPatchResponse200PetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesIdPatchResponse200PetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPatientProfilesIdPatchResponse200PetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesIdPatchResponse200ProfilePicture' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPatientProfilesIdPatchResponse200ProfilePictureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPublicProfilesPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesPostBodyPet' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPublicProfilesPostBodyPetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesPostBodyPetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPublicProfilesPostBodyPetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesPostBodyProfilePicture' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPublicProfilesPostBodyProfilePictureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPublicProfilesPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesPostResponse201Pet' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPublicProfilesPostResponse201PetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesPostResponse201PetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPublicProfilesPostResponse201PetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesPostResponse201ProfilePicture' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPublicProfilesPostResponse201ProfilePictureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesIdPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPublicProfilesIdPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesIdPatchBodyPetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPublicProfilesIdPatchBodyPetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesIdPatchBodyProfilePicture' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPublicProfilesIdPatchBodyProfilePictureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesIdPatchResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPublicProfilesIdPatchResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesIdPatchResponse200Pet' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPublicProfilesIdPatchResponse200PetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesIdPatchResponse200PetBreed' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPublicProfilesIdPatchResponse200PetBreedNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesIdPatchResponse200ProfilePicture' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetPublicProfilesIdPatchResponse200ProfilePictureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetSpeciesGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetSpeciesGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetSpeciesGetResponse200ItemAliasesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetSpeciesGetResponse200ItemAliasesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetSpeciesGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetSpeciesGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetSpeciesGetResponse206ItemAliasesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetSpeciesGetResponse206ItemAliasesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\OauthV2RevokeGetResponse400' => 'NoahVet\\Reef\\Jane\\Normalizer\\OauthV2RevokeGetResponse400Normalizer', 'NoahVet\\Reef\\Jane\\Model\\OauthV2TokenInfoTokenGetResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\OauthV2TokenInfoTokenGetResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\OauthV2TokenInfoTokenGetResponse401' => 'NoahVet\\Reef\\Jane\\Normalizer\\OauthV2TokenInfoTokenGetResponse401Normalizer', 'NoahVet\\Reef\\Jane\\Model\\UserinfoGetResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\UserinfoGetResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\UserinfoGetResponse401' => 'NoahVet\\Reef\\Jane\\Normalizer\\UserinfoGetResponse401Normalizer', 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\ApiV1ProductPricesGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse200ItemAlcyonProduct' => 'NoahVet\\Reef\\Jane\\Normalizer\\ApiV1ProductPricesGetResponse200ItemAlcyonProductNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse200ItemCentravetProduct' => 'NoahVet\\Reef\\Jane\\Normalizer\\ApiV1ProductPricesGetResponse200ItemCentravetProductNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse200ItemCovetoProduct' => 'NoahVet\\Reef\\Jane\\Normalizer\\ApiV1ProductPricesGetResponse200ItemCovetoProductNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\ApiV1ProductPricesGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse206ItemAlcyonProduct' => 'NoahVet\\Reef\\Jane\\Normalizer\\ApiV1ProductPricesGetResponse206ItemAlcyonProductNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse206ItemCentravetProduct' => 'NoahVet\\Reef\\Jane\\Normalizer\\ApiV1ProductPricesGetResponse206ItemCentravetProductNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse206ItemCovetoProduct' => 'NoahVet\\Reef\\Jane\\Normalizer\\ApiV1ProductPricesGetResponse206ItemCovetoProductNormalizer', '\\Jane\\Component\\JsonSchemaRuntime\\Reference' => '\\NoahVet\\Reef\\Jane\\Runtime\\Normalizer\\ReferenceNormalizer'];

    protected $normalizersCache = [];

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return \array_key_exists($type, $this->normalizers);
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && \array_key_exists($data::class, $this->normalizers);
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $normalizerClass = $this->normalizers[$object::class];
        $normalizer = $this->getNormalizer($normalizerClass);

        return $normalizer->normalize($object, $format, $context);
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        $denormalizerClass = $this->normalizers[$class];
        $denormalizer = $this->getNormalizer($denormalizerClass);

        return $denormalizer->denormalize($data, $class, $format, $context);
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\NullableIdResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\IdResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\BillingAccountResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\NullableIdRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\IdRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\BillingAccountRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasBillingAccountResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasBillingAccountResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasBillingAccountRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\BillingAccountResponseComponentsSchemasBillingAccountResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\YousignSignatureRequestResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\MandateResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasMandateResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\ContractResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\ContractRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\ContractDocumentResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\InvitationResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentUserInvitationRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentUserInvitationResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentUserInvitationConfirmationRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentUserInvitationConfirmationResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupUserInvitationRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupUserInvitationResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupUserInvitationConfirmationRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupUserInvitationConfirmationResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\InvoiceAddressResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\CreditNoteResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\CreditNoteResponseAccountingMovement' => false, 'NoahVet\\Reef\\Jane\\Model\\CreditNoteResponseBankAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\CreditNoteResponseCreditNoteLinesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\CreditNoteResponseDeliveryInformation' => false, 'NoahVet\\Reef\\Jane\\Model\\CreditNoteResponseReceiverInformation' => false, 'NoahVet\\Reef\\Jane\\Model\\CreditNoteResponseSenderInformation' => false, 'NoahVet\\Reef\\Jane\\Model\\InvoiceAddressRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\CreditNoteRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\CreditNoteRequestDeliveryInformation' => false, 'NoahVet\\Reef\\Jane\\Model\\CreditNoteRequestReceiverInformation' => false, 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItemAccountingMovement' => false, 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItemBankAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItemDeliveryInformation' => false, 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItemInvoiceLinesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItemReceiverInformation' => false, 'NoahVet\\Reef\\Jane\\Model\\InvoiceResponseItemSenderInformation' => false, 'NoahVet\\Reef\\Jane\\Model\\ServiceDeliveryInvoiceRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\ServiceDeliveryInvoiceResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\CoordinateResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\PostalAddressResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\LegalStructureResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\CoordinateRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\PostalAddressRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\LegalStructureRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasLegalStructureResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasLegalStructureResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasPostalAddressRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasLegalStructureRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\LegalStructureResponseComponentsSchemasLegalStructureResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\SearchRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\LegalStructureSearchResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\RequiredMandateResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\RequiredMandateResponseItemFilledMandate' => false, 'NoahVet\\Reef\\Jane\\Model\\RequiredMandateRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasRequiredMandateResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasRequiredMandateResponseFilledMandate' => false, 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasRequiredMandateResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasRequiredMandateResponseFilledMandate' => false, 'NoahVet\\Reef\\Jane\\Model\\ManufacturerResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\ManufacturerResponseItemBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\ManufacturerResponseItemLegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\ManufacturerResponseItemLogo' => false, 'NoahVet\\Reef\\Jane\\Model\\ManufacturerResponseItemPicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\DocumentResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\DocumentRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasDocumentResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\ImageResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\ImageRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasImageResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDeliveryResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDeliveryRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceDeliveryRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\ServiceDeliveryOptionResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\ServiceDeliveryOptionRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasServiceDeliveryOptionRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\ManufacturerUserResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\ManufacturerUserResponseItemManufacturer' => false, 'NoahVet\\Reef\\Jane\\Model\\ManufacturerUserResponseItemUser' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentUserResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentUserResponseItemUser' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentUserResponseItemVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentUserRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentUserResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentUserRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryEstablishmentUserResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupUserResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupUserResponseItemUser' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupUserResponseItemVeterinaryGroup' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupUserRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryGroupUserResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryGroupUserRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryGroupUserResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentAddressResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentAddressResponsePhone' => false, 'NoahVet\\Reef\\Jane\\Model\\OpeningHourResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\OpeningPeriodResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\ScheduleResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\OpeningHourRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\OpeningPeriodRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentRequestSchedule' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentRequestSchedule' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentAddressRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentAddressRequestPhone' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentAddressRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentAddressRequestPhone' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentCreditNoteResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentCreditNoteResponseItemModeration' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentCreditNoteResponseItemVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentCreditNoteRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentCreditNoteRequestModeration' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentCreditNoteResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentCreditNoteResponseModeration' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentCreditNoteResponseVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentCreditNoteRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryEstablishmentCreditNoteResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryEstablishmentCreditNoteResponseModeration' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentCreditNoteBulkRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentMemberResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentMemberRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentMemberRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentActivityResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentActivityRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentActivityResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentActivityRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryEstablishmentActivityResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentMandateResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentMandateRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentMandateRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServicePeriodResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServicePeriodResponseItemAttributesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceSubscriptionResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceSubscriptionResponseItemAttributesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceSubscriptionRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceSubscriptionRequestAttributesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceSubscriptionResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceSubscriptionResponseAttributesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceSubscriptionReductionRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceSubscriptionReductionResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceSubscriptionReductionResponseAttributesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceSubscriptionRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceSubscriptionRequestAttributesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponseAttributesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDiscountResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDiscountRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceDiscountResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceDiscountRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryEstablishmentServiceDiscountResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDeliveryDiscountResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDeliveryDiscountRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceDeliveryDiscountResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceDeliveryDiscountRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryEstablishmentServiceDeliveryDiscountResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentLabellingResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentLabellingRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentTagResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentTagRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentTagResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\ComponentsSchemasVeterinaryEstablishmentTagResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\MetadataResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\MetadataRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryGroupRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupMandateResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupMandateRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryGroupMandateRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryServiceResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryServiceResponseItemBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryServiceResponseItemCreditor' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryServiceOptionResponse' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryServiceOptionRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryServiceOptionConfigResponseItem' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryServiceOptionConfigResponseItemAccountingCodesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryServiceOptionConfigResponseItemVeterinaryServiceOption' => false, 'NoahVet\\Reef\\Jane\\Model\\YouSignContractConfirmationRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\YouSignContractConfirmationRequestData' => false, 'NoahVet\\Reef\\Jane\\Model\\YouSignContractConfirmationRequestDataSignatureRequest' => false, 'NoahVet\\Reef\\Jane\\Model\\Client' => false, 'NoahVet\\Reef\\Jane\\Model\\ClientGet' => false, 'NoahVet\\Reef\\Jane\\Model\\CountryTypeEnum' => false, 'NoahVet\\Reef\\Jane\\Model\\GrantedPermissionShort' => false, 'NoahVet\\Reef\\Jane\\Model\\InvitationEmailStatusEnum' => false, 'NoahVet\\Reef\\Jane\\Model\\PhoneValidationMethodEnum' => false, 'NoahVet\\Reef\\Jane\\Model\\PolicyResultPolicyResultGet' => false, 'NoahVet\\Reef\\Jane\\Model\\PolicyResultPolicyResultPost' => false, 'NoahVet\\Reef\\Jane\\Model\\PostalAddress' => false, 'NoahVet\\Reef\\Jane\\Model\\Principal' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalPrincipalGet' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalPrincipalPatch' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalPrincipalPut' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalGroup' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalInvitation' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalPhoneNumber' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalStatusEnum' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalTypeEnum' => false, 'NoahVet\\Reef\\Jane\\Model\\Resource' => false, 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupResourceGroupGet' => false, 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupResourceGroupPost' => false, 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupResourceGroupPut' => false, 'NoahVet\\Reef\\Jane\\Model\\ResourceType' => false, 'NoahVet\\Reef\\Jane\\Model\\ResourceTypeGetshort' => false, 'NoahVet\\Reef\\Jane\\Model\\PermissionGrant' => false, 'NoahVet\\Reef\\Jane\\Model\\PermissionGrantList' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalShort' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalGet' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalGetPhoneNumbersItem' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalPut' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalPutPhoneNumbersItem' => false, 'NoahVet\\Reef\\Jane\\Model\\ServicePermission' => false, 'NoahVet\\Reef\\Jane\\Model\\ServiceResource' => false, 'NoahVet\\Reef\\Jane\\Model\\ServiceExternalResource' => false, 'NoahVet\\Reef\\Jane\\Model\\ServiceDefinition' => false, 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupGet' => false, 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupPost' => false, 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupPut' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsGetResponse200ItemCompanyDetail' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsGetResponse200ItemCustomerProfile' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsGetResponse200ItemGeolocation' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsGetResponse206ItemCompanyDetail' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsGetResponse206ItemCustomerProfile' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsGetResponse206ItemGeolocation' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsPostBodyCompanyDetail' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsPostBodyCustomerProfile' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsPostBodyGeolocation' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsPostResponse201CompanyDetail' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsPostResponse201CustomerProfile' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsPostResponse201Geolocation' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsIdPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsIdPatchBodyCompanyDetail' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsIdPatchBodyGeolocation' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsIdPatchResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsIdPatchResponse200CompanyDetail' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsIdPatchResponse200CustomerProfile' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ContactsIdPatchResponse200Geolocation' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomersGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomersGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomersIdPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomersIdPatchResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse200ItemBillingContact' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse200ItemCustomer' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse200ItemDeliveryContact' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse200ItemMainContact' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse206ItemBillingContact' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse206ItemCustomer' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse206ItemDeliveryContact' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesGetResponse206ItemMainContact' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesPostBodyCustomer' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesPostResponse201BillingContact' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesPostResponse201Customer' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesPostResponse201DeliveryContact' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesPostResponse201MainContact' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchBodyBillingContact' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchBodyDeliveryContact' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchBodyMainContact' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchResponse200BillingContact' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchResponse200Customer' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchResponse200DeliveryContact' => false, 'NoahVet\\Reef\\Jane\\Model\\V1CustomerProfilesIdPatchResponse200MainContact' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse200ItemMicrochipsItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse200ItemTattoo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse200ItemSpecie' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse206ItemMicrochipsItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse206ItemTattoo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse206ItemSpecie' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostBodyTattoo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostBodySpecie' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostResponse201MicrochipsItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostResponse201Tattoo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostResponse201Specie' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsIdPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsIdPatchBodyTattoo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsIdPatchBodySpecie' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsIdPatchResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsIdPatchResponse200MicrochipsItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsIdPatchResponse200Tattoo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsIdPatchResponse200Specie' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsGetResponse200ItemAliasesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsGetResponse200ItemSpecie' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsGetResponse206ItemAliasesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsGetResponse206ItemSpecie' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostBodySpecie' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostBodyTranslations' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostBodyTranslationsEnGB' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostBodyTranslationsEnGBAliasesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostBodyTranslationsFrFR' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostBodyTranslationsFrFRAliasesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostResponse201AliasesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedsPostResponse201Specie' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksGetResponse200ItemExternalRef' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksGetResponse200ItemPetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksGetResponse206ItemExternalRef' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksGetResponse206ItemPetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksPostBodyPetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksPostBodyExternalRef' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksPostResponse201ExternalRef' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalLinksPostResponse201PetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalRefsGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalRefsGetResponse200ItemCoveredLocales' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalRefsGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalRefsGetResponse206ItemCoveredLocales' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalRefsPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalRefsPostBodyCoveredLocales' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalRefsPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedExternalRefsPostResponse201CoveredLocales' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsGetResponse200ItemPetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsGetResponse200ItemTag' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsGetResponse206ItemPetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsGetResponse206ItemTag' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsPostBodyPetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsPostBodyTag' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsPostResponse201PetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedLabellingsPostResponse201Tag' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedTagsGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedTagsGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedTagsPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedTagsPostBodyTranslations' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedTagsPostBodyTranslationsEnGB' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedTagsPostBodyTranslationsFrFR' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetBreedTagsPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetMicrochipsPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetMicrochipsPostBodyPet' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetMicrochipsPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetMicrochipsPostResponse201Pet' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetProfilesGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetProfilesGetResponse200ItemPet' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetProfilesGetResponse200ItemPetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetProfilesGetResponse200ItemProfilePicture' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetProfilesGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetProfilesGetResponse206ItemPet' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetProfilesGetResponse206ItemPetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetProfilesGetResponse206ItemProfilePicture' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesPostBodyPet' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesPostBodyPetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesPostBodyProfilePicture' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesPostResponse201Pet' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesPostResponse201PetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesPostResponse201ProfilePicture' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesIdPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesIdPatchBodyPetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesIdPatchBodyProfilePicture' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesIdPatchResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesIdPatchResponse200Pet' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesIdPatchResponse200PetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetCustomerProfilesIdPatchResponse200ProfilePicture' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesPostBodyPet' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesPostBodyPetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesPostBodyProfilePicture' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesPostResponse201Pet' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesPostResponse201PetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesPostResponse201ProfilePicture' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesIdPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesIdPatchBodyPetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesIdPatchBodyProfilePicture' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesIdPatchResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesIdPatchResponse200Pet' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesIdPatchResponse200PetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetGhostProfilesIdPatchResponse200ProfilePicture' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesPostBodyPet' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesPostBodyPetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesPostBodyProfilePicture' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesPostResponse201Pet' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesPostResponse201PetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesPostResponse201ProfilePicture' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesIdPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesIdPatchBodyPetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesIdPatchBodyProfilePicture' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesIdPatchResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesIdPatchResponse200Pet' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesIdPatchResponse200PetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPatientProfilesIdPatchResponse200ProfilePicture' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesPostBodyPet' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesPostBodyPetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesPostBodyProfilePicture' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesPostResponse201Pet' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesPostResponse201PetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesPostResponse201ProfilePicture' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesIdPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesIdPatchBodyPetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesIdPatchBodyProfilePicture' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesIdPatchResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesIdPatchResponse200Pet' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesIdPatchResponse200PetBreed' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetPublicProfilesIdPatchResponse200ProfilePicture' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetSpeciesGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetSpeciesGetResponse200ItemAliasesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetSpeciesGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetSpeciesGetResponse206ItemAliasesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\OauthV2RevokeGetResponse400' => false, 'NoahVet\\Reef\\Jane\\Model\\OauthV2TokenInfoTokenGetResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\OauthV2TokenInfoTokenGetResponse401' => false, 'NoahVet\\Reef\\Jane\\Model\\UserinfoGetResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\UserinfoGetResponse401' => false, 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse200ItemAlcyonProduct' => false, 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse200ItemCentravetProduct' => false, 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse200ItemCovetoProduct' => false, 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse206ItemAlcyonProduct' => false, 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse206ItemCentravetProduct' => false, 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse206ItemCovetoProduct' => false, '\\Jane\\Component\\JsonSchemaRuntime\\Reference' => false];
    }

    private function getNormalizer(string $normalizerClass)
    {
        return $this->normalizersCache[$normalizerClass] ?? $this->initNormalizer($normalizerClass);
    }

    private function initNormalizer(string $normalizerClass)
    {
        $normalizer = new $normalizerClass();
        $normalizer->setNormalizer($this->normalizer);
        $normalizer->setDenormalizer($this->denormalizer);
        $this->normalizersCache[$normalizerClass] = $normalizer;

        return $normalizer;
    }
}
