<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class ContractDocumentResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\ContractDocumentResponse' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\ContractDocumentResponse' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\ContractDocumentResponse();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('contract', $data)) {
            $object->setContract($this->denormalizer->denormalize($data['contract'], 'NoahVet\\Reef\\Jane\\Model\\IdResponse', 'json', $context));
            unset($data['contract']);
        }
        if (\array_key_exists('pdfDocument', $data)) {
            $object->setPdfDocument($this->denormalizer->denormalize($data['pdfDocument'], 'NoahVet\\Reef\\Jane\\Model\\IdResponse', 'json', $context));
            unset($data['pdfDocument']);
        }
        if (\array_key_exists('signedPdfDocument', $data)) {
            $object->setSignedPdfDocument($this->denormalizer->denormalize($data['signedPdfDocument'], 'NoahVet\\Reef\\Jane\\Model\\IdResponse', 'json', $context));
            unset($data['signedPdfDocument']);
        }
        if (\array_key_exists('signer', $data)) {
            $object->setSigner($this->denormalizer->denormalize($data['signer'], 'NoahVet\\Reef\\Jane\\Model\\IdResponse', 'json', $context));
            unset($data['signer']);
        }
        if (\array_key_exists('status', $data)) {
            $object->setStatus($data['status']);
            unset($data['status']);
        }
        if (\array_key_exists('validatedDate', $data) && null !== $data['validatedDate']) {
            $object->setValidatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['validatedDate']));
            unset($data['validatedDate']);
        } elseif (\array_key_exists('validatedDate', $data) && null === $data['validatedDate']) {
            $object->setValidatedDate(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['id'] = $object->getId();
        $data['createdDate'] = $object->getCreatedDate()->format('Y-m-d\\TH:i:sP');
        $data['updatedDate'] = $object->getUpdatedDate()->format('Y-m-d\\TH:i:sP');
        $data['contract'] = $this->normalizer->normalize($object->getContract(), 'json', $context);
        $data['pdfDocument'] = $this->normalizer->normalize($object->getPdfDocument(), 'json', $context);
        $data['signedPdfDocument'] = $this->normalizer->normalize($object->getSignedPdfDocument(), 'json', $context);
        $data['signer'] = $this->normalizer->normalize($object->getSigner(), 'json', $context);
        $data['status'] = $object->getStatus();
        $data['validatedDate'] = $object->getValidatedDate()->format('Y-m-d\\TH:i:sP');
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\ContractDocumentResponse' => false];
    }
}
