<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class ApiV1ProductPricesGetResponse200ItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse200Item' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse200Item' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\ApiV1ProductPricesGetResponse200Item();
        if (\array_key_exists('salePriceTaxIncl', $data) && \is_int($data['salePriceTaxIncl'])) {
            $data['salePriceTaxIncl'] = (float) $data['salePriceTaxIncl'];
        }
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('created', $data)) {
            $object->setCreated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['created']));
            unset($data['created']);
        }
        if (\array_key_exists('updated', $data)) {
            $object->setUpdated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updated']));
            unset($data['updated']);
        }
        if (\array_key_exists('alcyonProduct', $data) && null !== $data['alcyonProduct']) {
            $object->setAlcyonProduct($this->denormalizer->denormalize($data['alcyonProduct'], 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse200ItemAlcyonProduct', 'json', $context));
            unset($data['alcyonProduct']);
        } elseif (\array_key_exists('alcyonProduct', $data) && null === $data['alcyonProduct']) {
            $object->setAlcyonProduct(null);
        }
        if (\array_key_exists('centravetProduct', $data) && null !== $data['centravetProduct']) {
            $object->setCentravetProduct($this->denormalizer->denormalize($data['centravetProduct'], 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse200ItemCentravetProduct', 'json', $context));
            unset($data['centravetProduct']);
        } elseif (\array_key_exists('centravetProduct', $data) && null === $data['centravetProduct']) {
            $object->setCentravetProduct(null);
        }
        if (\array_key_exists('covetoProduct', $data) && null !== $data['covetoProduct']) {
            $object->setCovetoProduct($this->denormalizer->denormalize($data['covetoProduct'], 'NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse200ItemCovetoProduct', 'json', $context));
            unset($data['covetoProduct']);
        } elseif (\array_key_exists('covetoProduct', $data) && null === $data['covetoProduct']) {
            $object->setCovetoProduct(null);
        }
        if (\array_key_exists('ean', $data) && null !== $data['ean']) {
            $object->setEan($data['ean']);
            unset($data['ean']);
        } elseif (\array_key_exists('ean', $data) && null === $data['ean']) {
            $object->setEan(null);
        }
        if (\array_key_exists('gtin', $data) && null !== $data['gtin']) {
            $object->setGtin($data['gtin']);
            unset($data['gtin']);
        } elseif (\array_key_exists('gtin', $data) && null === $data['gtin']) {
            $object->setGtin(null);
        }
        if (\array_key_exists('salePriceTaxIncl', $data) && null !== $data['salePriceTaxIncl']) {
            $object->setSalePriceTaxIncl($data['salePriceTaxIncl']);
            unset($data['salePriceTaxIncl']);
        } elseif (\array_key_exists('salePriceTaxIncl', $data) && null === $data['salePriceTaxIncl']) {
            $object->setSalePriceTaxIncl(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['created'] = $object->getCreated()->format('Y-m-d\\TH:i:sP');
        $data['updated'] = $object->getUpdated()->format('Y-m-d\\TH:i:sP');
        $data['alcyonProduct'] = $this->normalizer->normalize($object->getAlcyonProduct(), 'json', $context);
        $data['centravetProduct'] = $this->normalizer->normalize($object->getCentravetProduct(), 'json', $context);
        $data['covetoProduct'] = $this->normalizer->normalize($object->getCovetoProduct(), 'json', $context);
        $data['ean'] = $object->getEan();
        $data['gtin'] = $object->getGtin();
        $data['salePriceTaxIncl'] = $object->getSalePriceTaxIncl();
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\ApiV1ProductPricesGetResponse200Item' => false];
    }
}
