<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryServiceResponseItem extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var VeterinaryServiceResponseItemBanner|null
     */
    protected $banner;

    /**
     * @var string
     */
    protected $code;

    /**
     * @var VeterinaryServiceResponseItemCreditor
     */
    protected $creditor;

    /**
     * @var string
     */
    protected $entitled;

    /**
     * @var IdResponse[]
     */
    protected $pictures;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    public function getBanner(): ?VeterinaryServiceResponseItemBanner
    {
        return $this->banner;
    }

    public function setBanner(?VeterinaryServiceResponseItemBanner $banner): self
    {
        $this->initialized['banner'] = true;
        $this->banner = $banner;

        return $this;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->initialized['code'] = true;
        $this->code = $code;

        return $this;
    }

    public function getCreditor(): VeterinaryServiceResponseItemCreditor
    {
        return $this->creditor;
    }

    public function setCreditor(VeterinaryServiceResponseItemCreditor $creditor): self
    {
        $this->initialized['creditor'] = true;
        $this->creditor = $creditor;

        return $this;
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function setEntitled(string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    /**
     * @return IdResponse[]
     */
    public function getPictures(): array
    {
        return $this->pictures;
    }

    /**
     * @param IdResponse[] $pictures
     */
    public function setPictures(array $pictures): self
    {
        $this->initialized['pictures'] = true;
        $this->pictures = $pictures;

        return $this;
    }
}
