<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryServiceOptionResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var string|null
     */
    protected $accountingCode;

    /**
     * Nullable Id - Response Model.
     *
     * @var NullableIdResponse|null
     */
    protected $banner;

    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $entitled;

    /**
     * @var string
     */
    protected $invoiceLineEntitledPattern;

    /**
     * @var IdResponse[]
     */
    protected $pictures;

    /**
     * @var string
     */
    protected $status;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $veterinaryService;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    public function getAccountingCode(): ?string
    {
        return $this->accountingCode;
    }

    public function setAccountingCode(?string $accountingCode): self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;

        return $this;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function getBanner(): ?NullableIdResponse
    {
        return $this->banner;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function setBanner(?NullableIdResponse $banner): self
    {
        $this->initialized['banner'] = true;
        $this->banner = $banner;

        return $this;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->initialized['code'] = true;
        $this->code = $code;

        return $this;
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function setEntitled(string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    public function getInvoiceLineEntitledPattern(): string
    {
        return $this->invoiceLineEntitledPattern;
    }

    public function setInvoiceLineEntitledPattern(string $invoiceLineEntitledPattern): self
    {
        $this->initialized['invoiceLineEntitledPattern'] = true;
        $this->invoiceLineEntitledPattern = $invoiceLineEntitledPattern;

        return $this;
    }

    /**
     * @return IdResponse[]
     */
    public function getPictures(): array
    {
        return $this->pictures;
    }

    /**
     * @param IdResponse[] $pictures
     */
    public function setPictures(array $pictures): self
    {
        $this->initialized['pictures'] = true;
        $this->pictures = $pictures;

        return $this;
    }

    public function getStatus(): string
    {
        return $this->status;
    }

    public function setStatus(string $status): self
    {
        $this->initialized['status'] = true;
        $this->status = $status;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getVeterinaryService(): IdResponse
    {
        return $this->veterinaryService;
    }

    /**
     * Id - Response Model.
     */
    public function setVeterinaryService(IdResponse $veterinaryService): self
    {
        $this->initialized['veterinaryService'] = true;
        $this->veterinaryService = $veterinaryService;

        return $this;
    }
}
