<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryServiceOptionConfigResponseItem extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var VeterinaryServiceOptionConfigResponseItemAccountingCodesItem[]
     */
    protected $accountingCodes;

    /**
     * @var array<string, mixed>[]
     */
    protected $attributes;

    /**
     * @var VeterinaryServiceOptionConfigResponseItemVeterinaryServiceOption
     */
    protected $veterinaryServiceOption;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * @return VeterinaryServiceOptionConfigResponseItemAccountingCodesItem[]
     */
    public function getAccountingCodes(): array
    {
        return $this->accountingCodes;
    }

    /**
     * @param VeterinaryServiceOptionConfigResponseItemAccountingCodesItem[] $accountingCodes
     */
    public function setAccountingCodes(array $accountingCodes): self
    {
        $this->initialized['accountingCodes'] = true;
        $this->accountingCodes = $accountingCodes;

        return $this;
    }

    /**
     * @return array<string, mixed>[]
     */
    public function getAttributes(): array
    {
        return $this->attributes;
    }

    /**
     * @param array<string, mixed>[] $attributes
     */
    public function setAttributes(array $attributes): self
    {
        $this->initialized['attributes'] = true;
        $this->attributes = $attributes;

        return $this;
    }

    public function getVeterinaryServiceOption(): VeterinaryServiceOptionConfigResponseItemVeterinaryServiceOption
    {
        return $this->veterinaryServiceOption;
    }

    public function setVeterinaryServiceOption(VeterinaryServiceOptionConfigResponseItemVeterinaryServiceOption $veterinaryServiceOption): self
    {
        $this->initialized['veterinaryServiceOption'] = true;
        $this->veterinaryServiceOption = $veterinaryServiceOption;

        return $this;
    }
}
