<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryGroupMandateRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $accountingCode;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $mandate;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $veterinaryGroup;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getAccountingCode(): string
    {
        return $this->accountingCode;
    }

    public function setAccountingCode(string $accountingCode): self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getMandate(): IdRequest
    {
        return $this->mandate;
    }

    /**
     * Id - Common Request Model.
     */
    public function setMandate(IdRequest $mandate): self
    {
        $this->initialized['mandate'] = true;
        $this->mandate = $mandate;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getVeterinaryGroup(): IdRequest
    {
        return $this->veterinaryGroup;
    }

    /**
     * Id - Common Request Model.
     */
    public function setVeterinaryGroup(IdRequest $veterinaryGroup): self
    {
        $this->initialized['veterinaryGroup'] = true;
        $this->veterinaryGroup = $veterinaryGroup;

        return $this;
    }
}
