<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentServiceSubscriptionReductionResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var VeterinaryEstablishmentServiceSubscriptionReductionResponseAttributesItem[]
     */
    protected $attributes;

    /**
     * @var \DateTime
     */
    protected $endDate;

    /**
     * @var bool
     */
    protected $isRenewal;

    /**
     * @var string
     */
    protected $paymentMethod;

    /**
     * Nullable Id - Response Model.
     *
     * @var NullableIdResponse|null
     */
    protected $specificBillingAccount;

    /**
     * Nullable Id - Response Model.
     *
     * @var NullableIdResponse|null
     */
    protected $specificVeterinaryGroup;

    /**
     * @var \DateTime
     */
    protected $startDate;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $veterinaryEstablishment;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $veterinaryServiceOption;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    /**
     * @return VeterinaryEstablishmentServiceSubscriptionReductionResponseAttributesItem[]
     */
    public function getAttributes(): array
    {
        return $this->attributes;
    }

    /**
     * @param VeterinaryEstablishmentServiceSubscriptionReductionResponseAttributesItem[] $attributes
     */
    public function setAttributes(array $attributes): self
    {
        $this->initialized['attributes'] = true;
        $this->attributes = $attributes;

        return $this;
    }

    public function getEndDate(): \DateTime
    {
        return $this->endDate;
    }

    public function setEndDate(\DateTime $endDate): self
    {
        $this->initialized['endDate'] = true;
        $this->endDate = $endDate;

        return $this;
    }

    public function getIsRenewal(): bool
    {
        return $this->isRenewal;
    }

    public function setIsRenewal(bool $isRenewal): self
    {
        $this->initialized['isRenewal'] = true;
        $this->isRenewal = $isRenewal;

        return $this;
    }

    public function getPaymentMethod(): string
    {
        return $this->paymentMethod;
    }

    public function setPaymentMethod(string $paymentMethod): self
    {
        $this->initialized['paymentMethod'] = true;
        $this->paymentMethod = $paymentMethod;

        return $this;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function getSpecificBillingAccount(): ?NullableIdResponse
    {
        return $this->specificBillingAccount;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function setSpecificBillingAccount(?NullableIdResponse $specificBillingAccount): self
    {
        $this->initialized['specificBillingAccount'] = true;
        $this->specificBillingAccount = $specificBillingAccount;

        return $this;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function getSpecificVeterinaryGroup(): ?NullableIdResponse
    {
        return $this->specificVeterinaryGroup;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function setSpecificVeterinaryGroup(?NullableIdResponse $specificVeterinaryGroup): self
    {
        $this->initialized['specificVeterinaryGroup'] = true;
        $this->specificVeterinaryGroup = $specificVeterinaryGroup;

        return $this;
    }

    public function getStartDate(): \DateTime
    {
        return $this->startDate;
    }

    public function setStartDate(\DateTime $startDate): self
    {
        $this->initialized['startDate'] = true;
        $this->startDate = $startDate;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getVeterinaryEstablishment(): IdResponse
    {
        return $this->veterinaryEstablishment;
    }

    /**
     * Id - Response Model.
     */
    public function setVeterinaryEstablishment(IdResponse $veterinaryEstablishment): self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getVeterinaryServiceOption(): IdResponse
    {
        return $this->veterinaryServiceOption;
    }

    /**
     * Id - Response Model.
     */
    public function setVeterinaryServiceOption(IdResponse $veterinaryServiceOption): self
    {
        $this->initialized['veterinaryServiceOption'] = true;
        $this->veterinaryServiceOption = $veterinaryServiceOption;

        return $this;
    }
}
