<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1PetsIdPatchBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var bool|null
     */
    protected $isAnonymous;

    /**
     * @var string|null
     */
    protected $name;

    /**
     * @var string|null
     */
    protected $passportNumber;

    /**
     * @var V1PetsIdPatchBodyTattoo|null
     */
    protected $tattoo;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var V1PetsIdPatchBodySpecie|null
     */
    protected $specie;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getIsAnonymous(): ?bool
    {
        return $this->isAnonymous;
    }

    public function setIsAnonymous(?bool $isAnonymous): self
    {
        $this->initialized['isAnonymous'] = true;
        $this->isAnonymous = $isAnonymous;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->initialized['name'] = true;
        $this->name = $name;

        return $this;
    }

    public function getPassportNumber(): ?string
    {
        return $this->passportNumber;
    }

    public function setPassportNumber(?string $passportNumber): self
    {
        $this->initialized['passportNumber'] = true;
        $this->passportNumber = $passportNumber;

        return $this;
    }

    public function getTattoo(): ?V1PetsIdPatchBodyTattoo
    {
        return $this->tattoo;
    }

    public function setTattoo(?V1PetsIdPatchBodyTattoo $tattoo): self
    {
        $this->initialized['tattoo'] = true;
        $this->tattoo = $tattoo;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getSpecie(): ?V1PetsIdPatchBodySpecie
    {
        return $this->specie;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setSpecie(?V1PetsIdPatchBodySpecie $specie): self
    {
        $this->initialized['specie'] = true;
        $this->specie = $specie;

        return $this;
    }
}
