<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1ContactsIdPatchBodyCompanyDetail extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $legalCode;

    /**
     * @var string|null
     */
    protected $name;

    /**
     * @var string|null
     */
    protected $serviceName;

    /**
     * @var string|null
     */
    protected $type;

    /**
     * @var string|null
     */
    protected $vatIntraCommunityNumber;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getLegalCode(): ?string
    {
        return $this->legalCode;
    }

    public function setLegalCode(?string $legalCode): self
    {
        $this->initialized['legalCode'] = true;
        $this->legalCode = $legalCode;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->initialized['name'] = true;
        $this->name = $name;

        return $this;
    }

    public function getServiceName(): ?string
    {
        return $this->serviceName;
    }

    public function setServiceName(?string $serviceName): self
    {
        $this->initialized['serviceName'] = true;
        $this->serviceName = $serviceName;

        return $this;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(?string $type): self
    {
        $this->initialized['type'] = true;
        $this->type = $type;

        return $this;
    }

    public function getVatIntraCommunityNumber(): ?string
    {
        return $this->vatIntraCommunityNumber;
    }

    public function setVatIntraCommunityNumber(?string $vatIntraCommunityNumber): self
    {
        $this->initialized['vatIntraCommunityNumber'] = true;
        $this->vatIntraCommunityNumber = $vatIntraCommunityNumber;

        return $this;
    }
}
