<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class ServiceDeliveryOptionResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var string|null
     */
    protected $accountingCode;

    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $description;

    /**
     * @var string
     */
    protected $entitled;

    /**
     * @var string
     */
    protected $invoiceLineEntitledPattern;

    /**
     * @var string
     */
    protected $type;

    /**
     * @var int
     */
    protected $unitPriceWithoutVat;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $veterinaryService;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    public function getAccountingCode(): ?string
    {
        return $this->accountingCode;
    }

    public function setAccountingCode(?string $accountingCode): self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;

        return $this;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->initialized['code'] = true;
        $this->code = $code;

        return $this;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    public function setDescription(string $description): self
    {
        $this->initialized['description'] = true;
        $this->description = $description;

        return $this;
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function setEntitled(string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    public function getInvoiceLineEntitledPattern(): string
    {
        return $this->invoiceLineEntitledPattern;
    }

    public function setInvoiceLineEntitledPattern(string $invoiceLineEntitledPattern): self
    {
        $this->initialized['invoiceLineEntitledPattern'] = true;
        $this->invoiceLineEntitledPattern = $invoiceLineEntitledPattern;

        return $this;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): self
    {
        $this->initialized['type'] = true;
        $this->type = $type;

        return $this;
    }

    public function getUnitPriceWithoutVat(): int
    {
        return $this->unitPriceWithoutVat;
    }

    public function setUnitPriceWithoutVat(int $unitPriceWithoutVat): self
    {
        $this->initialized['unitPriceWithoutVat'] = true;
        $this->unitPriceWithoutVat = $unitPriceWithoutVat;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getVeterinaryService(): IdResponse
    {
        return $this->veterinaryService;
    }

    /**
     * Id - Response Model.
     */
    public function setVeterinaryService(IdResponse $veterinaryService): self
    {
        $this->initialized['veterinaryService'] = true;
        $this->veterinaryService = $veterinaryService;

        return $this;
    }
}
