<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class ServiceDeliveryInvoiceRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var IdRequest[]
     */
    protected $veterinaryEstablishmentServiceDeliveries;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * @return IdRequest[]
     */
    public function getVeterinaryEstablishmentServiceDeliveries(): array
    {
        return $this->veterinaryEstablishmentServiceDeliveries;
    }

    /**
     * @param IdRequest[] $veterinaryEstablishmentServiceDeliveries
     */
    public function setVeterinaryEstablishmentServiceDeliveries(array $veterinaryEstablishmentServiceDeliveries): self
    {
        $this->initialized['veterinaryEstablishmentServiceDeliveries'] = true;
        $this->veterinaryEstablishmentServiceDeliveries = $veterinaryEstablishmentServiceDeliveries;

        return $this;
    }
}
