<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class SchemasVeterinaryEstablishmentServiceDeliveryRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $accountingCode;

    /**
     * @var \DateTime|null
     */
    protected $completionDate;

    /**
     * @var string|null
     */
    protected $internalCommentary;

    /**
     * @var \DateTime|null
     */
    protected $invoiceDate;

    /**
     * @var string|null
     */
    protected $longDescription;

    /**
     * @var string|null
     */
    protected $paymentMethod;

    /**
     * @var bool|null
     */
    protected $shouldGenerateInvoice;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $specificBillingAccount;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $specificVeterinaryGroup;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getAccountingCode(): ?string
    {
        return $this->accountingCode;
    }

    public function setAccountingCode(?string $accountingCode): self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;

        return $this;
    }

    public function getCompletionDate(): ?\DateTime
    {
        return $this->completionDate;
    }

    public function setCompletionDate(?\DateTime $completionDate): self
    {
        $this->initialized['completionDate'] = true;
        $this->completionDate = $completionDate;

        return $this;
    }

    public function getInternalCommentary(): ?string
    {
        return $this->internalCommentary;
    }

    public function setInternalCommentary(?string $internalCommentary): self
    {
        $this->initialized['internalCommentary'] = true;
        $this->internalCommentary = $internalCommentary;

        return $this;
    }

    public function getInvoiceDate(): ?\DateTime
    {
        return $this->invoiceDate;
    }

    public function setInvoiceDate(?\DateTime $invoiceDate): self
    {
        $this->initialized['invoiceDate'] = true;
        $this->invoiceDate = $invoiceDate;

        return $this;
    }

    public function getLongDescription(): ?string
    {
        return $this->longDescription;
    }

    public function setLongDescription(?string $longDescription): self
    {
        $this->initialized['longDescription'] = true;
        $this->longDescription = $longDescription;

        return $this;
    }

    public function getPaymentMethod(): ?string
    {
        return $this->paymentMethod;
    }

    public function setPaymentMethod(?string $paymentMethod): self
    {
        $this->initialized['paymentMethod'] = true;
        $this->paymentMethod = $paymentMethod;

        return $this;
    }

    public function getShouldGenerateInvoice(): ?bool
    {
        return $this->shouldGenerateInvoice;
    }

    public function setShouldGenerateInvoice(?bool $shouldGenerateInvoice): self
    {
        $this->initialized['shouldGenerateInvoice'] = true;
        $this->shouldGenerateInvoice = $shouldGenerateInvoice;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getSpecificBillingAccount(): ?NullableIdRequest
    {
        return $this->specificBillingAccount;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setSpecificBillingAccount(?NullableIdRequest $specificBillingAccount): self
    {
        $this->initialized['specificBillingAccount'] = true;
        $this->specificBillingAccount = $specificBillingAccount;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getSpecificVeterinaryGroup(): ?NullableIdRequest
    {
        return $this->specificVeterinaryGroup;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setSpecificVeterinaryGroup(?NullableIdRequest $specificVeterinaryGroup): self
    {
        $this->initialized['specificVeterinaryGroup'] = true;
        $this->specificVeterinaryGroup = $specificVeterinaryGroup;

        return $this;
    }
}
