<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class SchemasVeterinaryEstablishmentActivityRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var int|null
     */
    protected $caninePercent;

    /**
     * @var int|null
     */
    protected $equinePercent;

    /**
     * @var int|null
     */
    protected $ruralPercent;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getCaninePercent(): ?int
    {
        return $this->caninePercent;
    }

    public function setCaninePercent(?int $caninePercent): self
    {
        $this->initialized['caninePercent'] = true;
        $this->caninePercent = $caninePercent;

        return $this;
    }

    public function getEquinePercent(): ?int
    {
        return $this->equinePercent;
    }

    public function setEquinePercent(?int $equinePercent): self
    {
        $this->initialized['equinePercent'] = true;
        $this->equinePercent = $equinePercent;

        return $this;
    }

    public function getRuralPercent(): ?int
    {
        return $this->ruralPercent;
    }

    public function setRuralPercent(?int $ruralPercent): self
    {
        $this->initialized['ruralPercent'] = true;
        $this->ruralPercent = $ruralPercent;

        return $this;
    }
}
